<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest;

use Twilio\Domain;
use Twilio\Exceptions\TwilioException;
use Twilio\Rest\Video\V1;

/**
 * @property \Twilio\Rest\Video\V1 $v1
 * @property \Twilio\Rest\Video\V1\CompositionList $compositions
 * @property \Twilio\Rest\Video\V1\CompositionHookList $compositionHooks
 * @property \Twilio\Rest\Video\V1\CompositionSettingsList $compositionSettings
 * @property \Twilio\Rest\Video\V1\RecordingList $recordings
 * @property \Twilio\Rest\Video\V1\RecordingSettingsList $recordingSettings
 * @property \Twilio\Rest\Video\V1\RoomList $rooms
 * @method \Twilio\Rest\Video\V1\CompositionContext compositions(string $sid)
 * @method \Twilio\Rest\Video\V1\CompositionHookContext compositionHooks(string $sid)
 * @method \Twilio\Rest\Video\V1\CompositionSettingsContext compositionSettings()
 * @method \Twilio\Rest\Video\V1\RecordingContext recordings(string $sid)
 * @method \Twilio\Rest\Video\V1\RecordingSettingsContext recordingSettings()
 * @method \Twilio\Rest\Video\V1\RoomContext rooms(string $sid)
 */
class Video extends Domain {
    protected $_v1;

    /**
     * Construct the Video Domain
     *
     * @param Client $client Client to communicate with Twilio
     */
    public function __construct(Client $client) {
        parent::__construct($client);

        $this->baseUrl = 'https://video.twilio.com';
    }

    /**
     * @return V1 Version v1 of video
     */
    protected function getV1(): V1 {
        if (!$this->_v1) {
            $this->_v1 = new V1($this);
        }
        return $this->_v1;
    }

    /**
     * Magic getter to lazy load version
     *
     * @param string $name Version to return
     * @return \Twilio\Version The requested version
     * @throws TwilioException For unknown versions
     */
    public function __get(string $name) {
        $method = 'get' . \ucfirst($name);
        if (\method_exists($this, $method)) {
            return $this->$method();
        }

        throw new TwilioException('Unknown version ' . $name);
    }

    /**
     * Magic caller to get resource contexts
     *
     * @param string $name Resource to return
     * @param array $arguments Context parameters
     * @return \Twilio\InstanceContext The requested resource context
     * @throws TwilioException For unknown resource
     */
    public function __call(string $name, array $arguments) {
        $method = 'context' . \ucfirst($name);
        if (\method_exists($this, $method)) {
            return \call_user_func_array([$this, $method], $arguments);
        }

        throw new TwilioException('Unknown context ' . $name);
    }

    protected function getCompositions(): \Twilio\Rest\Video\V1\CompositionList {
        return $this->v1->compositions;
    }

    /**
     * @param string $sid The SID that identifies the resource to fetch
     */
    protected function contextCompositions(string $sid): \Twilio\Rest\Video\V1\CompositionContext {
        return $this->v1->compositions($sid);
    }

    protected function getCompositionHooks(): \Twilio\Rest\Video\V1\CompositionHookList {
        return $this->v1->compositionHooks;
    }

    /**
     * @param string $sid The SID that identifies the resource to fetch
     */
    protected function contextCompositionHooks(string $sid): \Twilio\Rest\Video\V1\CompositionHookContext {
        return $this->v1->compositionHooks($sid);
    }

    protected function getCompositionSettings(): \Twilio\Rest\Video\V1\CompositionSettingsList {
        return $this->v1->compositionSettings;
    }

    protected function contextCompositionSettings(): \Twilio\Rest\Video\V1\CompositionSettingsContext {
        return $this->v1->compositionSettings();
    }

    protected function getRecordings(): \Twilio\Rest\Video\V1\RecordingList {
        return $this->v1->recordings;
    }

    /**
     * @param string $sid The SID that identifies the resource to fetch
     */
    protected function contextRecordings(string $sid): \Twilio\Rest\Video\V1\RecordingContext {
        return $this->v1->recordings($sid);
    }

    protected function getRecordingSettings(): \Twilio\Rest\Video\V1\RecordingSettingsList {
        return $this->v1->recordingSettings;
    }

    protected function contextRecordingSettings(): \Twilio\Rest\Video\V1\RecordingSettingsContext {
        return $this->v1->recordingSettings();
    }

    protected function getRooms(): \Twilio\Rest\Video\V1\RoomList {
        return $this->v1->rooms;
    }

    /**
     * @param string $sid The SID that identifies the resource to fetch
     */
    protected function contextRooms(string $sid): \Twilio\Rest\Video\V1\RoomContext {
        return $this->v1->rooms($sid);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        return '[Twilio.Video]';
    }
}