SET foreign_key_checks = 0;
#
# TABLE STRUCTURE FOR: ac_accounts
#

DROP TABLE IF EXISTS `ac_accounts`;

CREATE TABLE `ac_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `count_id` int(11) DEFAULT NULL,
  `store_id` int(11) DEFAULT NULL,
  `parent_id` int(11) DEFAULT NULL,
  `sort_code` varchar(100) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `account_name` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `account_code` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `balance` double(20,4) DEFAULT NULL,
  `note` text CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `created_by` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `system_ip` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `system_name` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `delete_bit` int(11) DEFAULT 0,
  `account_selection_name` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `paymenttypes_id` int(11) DEFAULT NULL,
  `customer_id` int(11) DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `expense_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `paymenttypes_id` (`paymenttypes_id`),
  KEY `customer_id` (`customer_id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `expense_id` (`expense_id`),
  CONSTRAINT `ac_accounts_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_accounts_ibfk_2` FOREIGN KEY (`paymenttypes_id`) REFERENCES `db_paymenttypes` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_accounts_ibfk_3` FOREIGN KEY (`customer_id`) REFERENCES `db_customers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_accounts_ibfk_4` FOREIGN KEY (`supplier_id`) REFERENCES `db_suppliers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_accounts_ibfk_5` FOREIGN KEY (`expense_id`) REFERENCES `db_expense` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `ac_accounts` (`id`, `count_id`, `store_id`, `parent_id`, `sort_code`, `account_name`, `account_code`, `balance`, `note`, `created_by`, `created_date`, `created_time`, `system_ip`, `system_name`, `status`, `delete_bit`, `account_selection_name`, `paymenttypes_id`, `customer_id`, `supplier_id`, `expense_id`) VALUES (1, 1, 2, 0, '1', 'Cash Box', 'Cash', '5000.0000', '', 'user_67930', '2024-07-09', '12:53:17 am', '::1', 'DESKTOP-GMFRN98', 1, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `ac_accounts` (`id`, `count_id`, `store_id`, `parent_id`, `sort_code`, `account_name`, `account_code`, `balance`, `note`, `created_by`, `created_date`, `created_time`, `system_ip`, `system_name`, `status`, `delete_bit`, `account_selection_name`, `paymenttypes_id`, `customer_id`, `supplier_id`, `expense_id`) VALUES (2, 2, 2, 0, '2', 'EBL Bank', '108059345444', '500.0000', '', 'user_67930', '2024-07-09', '12:53:36 am', '::1', 'DESKTOP-GMFRN98', 1, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `ac_accounts` (`id`, `count_id`, `store_id`, `parent_id`, `sort_code`, `account_name`, `account_code`, `balance`, `note`, `created_by`, `created_date`, `created_time`, `system_ip`, `system_name`, `status`, `delete_bit`, `account_selection_name`, `paymenttypes_id`, `customer_id`, `supplier_id`, `expense_id`) VALUES (3, 3, 2, 0, '3', 'DBL Bank', '45887111555', '108.0000', '', 'user_67930', '2024-07-09', '12:53:57 am', '::1', 'DESKTOP-GMFRN98', 1, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `ac_accounts` (`id`, `count_id`, `store_id`, `parent_id`, `sort_code`, `account_name`, `account_code`, `balance`, `note`, `created_by`, `created_date`, `created_time`, `system_ip`, `system_name`, `status`, `delete_bit`, `account_selection_name`, `paymenttypes_id`, `customer_id`, `supplier_id`, `expense_id`) VALUES (4, 4, 2, 0, '4', 'Baksh Merchant', '01775457008', '0.0000', '', 'user_67930', '2024-07-09', '12:54:12 am', '::1', 'DESKTOP-GMFRN98', 1, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `ac_accounts` (`id`, `count_id`, `store_id`, `parent_id`, `sort_code`, `account_name`, `account_code`, `balance`, `note`, `created_by`, `created_date`, `created_time`, `system_ip`, `system_name`, `status`, `delete_bit`, `account_selection_name`, `paymenttypes_id`, `customer_id`, `supplier_id`, `expense_id`) VALUES (5, 5, 2, 0, '5', 'Nagod Personal', '01954578089', '0.0000', '', 'user_67930', '2024-07-09', '12:54:30 am', '::1', 'DESKTOP-GMFRN98', 1, 0, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `ac_accounts` (`id`, `count_id`, `store_id`, `parent_id`, `sort_code`, `account_name`, `account_code`, `balance`, `note`, `created_by`, `created_date`, `created_time`, `system_ip`, `system_name`, `status`, `delete_bit`, `account_selection_name`, `paymenttypes_id`, `customer_id`, `supplier_id`, `expense_id`) VALUES (6, 6, 2, 0, '6', 'Rocket Personal', '019545780891', '0.0000', '', 'user_67930', '2024-07-09', '12:54:49 am', '::1', 'DESKTOP-GMFRN98', 1, 0, NULL, NULL, NULL, NULL, NULL);


#
# TABLE STRUCTURE FOR: ac_moneydeposits
#

DROP TABLE IF EXISTS `ac_moneydeposits`;

CREATE TABLE `ac_moneydeposits` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `deposit_date` date DEFAULT NULL,
  `reference_no` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `debit_account_id` int(11) DEFAULT NULL,
  `credit_account_id` int(11) DEFAULT NULL,
  `amount` double(20,4) DEFAULT NULL,
  `note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_date` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `system_ip` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `system_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `from_account_id` (`debit_account_id`),
  KEY `to_account_id` (`credit_account_id`),
  KEY `db_moneydeposits_ibfk_3` (`store_id`),
  CONSTRAINT `ac_moneydeposits_ibfk_1` FOREIGN KEY (`debit_account_id`) REFERENCES `ac_accounts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_moneydeposits_ibfk_2` FOREIGN KEY (`credit_account_id`) REFERENCES `ac_accounts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_moneydeposits_ibfk_3` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: ac_moneytransfer
#

DROP TABLE IF EXISTS `ac_moneytransfer`;

CREATE TABLE `ac_moneytransfer` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `count_id` int(11) DEFAULT NULL,
  `transfer_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `transfer_date` date DEFAULT NULL,
  `reference_no` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `debit_account_id` int(11) DEFAULT NULL,
  `credit_account_id` int(11) DEFAULT NULL,
  `amount` double(20,4) DEFAULT NULL,
  `note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_date` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `system_ip` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `system_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `from_account_id` (`debit_account_id`),
  KEY `to_account_id` (`credit_account_id`),
  KEY `db_moneytransfer_ibfk_3` (`store_id`),
  CONSTRAINT `ac_moneytransfer_ibfk_1` FOREIGN KEY (`debit_account_id`) REFERENCES `ac_accounts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_moneytransfer_ibfk_2` FOREIGN KEY (`credit_account_id`) REFERENCES `ac_accounts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_moneytransfer_ibfk_3` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: ac_transactions
#

DROP TABLE IF EXISTS `ac_transactions`;

CREATE TABLE `ac_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `payment_code` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `transaction_date` date DEFAULT NULL,
  `transaction_type` varchar(100) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `debit_account_id` int(11) DEFAULT NULL,
  `credit_account_id` int(11) DEFAULT NULL,
  `debit_amt` double(20,4) DEFAULT NULL,
  `credit_amt` double(20,4) DEFAULT NULL,
  `note` text CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `created_by` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `ref_accounts_id` int(11) DEFAULT NULL COMMENT 'reference table',
  `ref_moneytransfer_id` int(11) DEFAULT NULL COMMENT 'reference table',
  `ref_moneydeposits_id` int(11) DEFAULT NULL COMMENT 'reference table',
  `ref_salespayments_id` int(11) DEFAULT NULL,
  `ref_salespaymentsreturn_id` int(11) DEFAULT NULL,
  `ref_purchasepayments_id` int(11) DEFAULT NULL,
  `ref_purchasepaymentsreturn_id` int(11) DEFAULT NULL,
  `ref_expense_id` int(11) DEFAULT NULL,
  `customer_id` int(11) DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `short_code` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `journal_id` (`transaction_type`),
  KEY `account_id` (`debit_account_id`),
  KEY `store_id` (`store_id`),
  KEY `ac_accounts_id` (`ref_accounts_id`),
  KEY `ac_moneytransfer_id` (`ref_moneytransfer_id`),
  KEY `ac_moneydeposits_id` (`ref_moneydeposits_id`),
  KEY `customer_id` (`customer_id`),
  KEY `ref_salespayments_id` (`ref_salespayments_id`),
  KEY `ref_purchasepayments_id` (`ref_purchasepayments_id`),
  KEY `ref_purchasepaymentsreturn_id` (`ref_purchasepaymentsreturn_id`),
  KEY `ac_transactions_ibfk_9` (`ref_salespaymentsreturn_id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `ref_expense_id` (`ref_expense_id`),
  CONSTRAINT `ac_transactions_ibfk_10` FOREIGN KEY (`ref_purchasepayments_id`) REFERENCES `db_purchasepayments` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_transactions_ibfk_11` FOREIGN KEY (`ref_purchasepaymentsreturn_id`) REFERENCES `db_purchasepaymentsreturn` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_transactions_ibfk_12` FOREIGN KEY (`supplier_id`) REFERENCES `db_suppliers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_transactions_ibfk_13` FOREIGN KEY (`ref_expense_id`) REFERENCES `db_expense` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_transactions_ibfk_3` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_transactions_ibfk_4` FOREIGN KEY (`ref_accounts_id`) REFERENCES `ac_accounts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_transactions_ibfk_5` FOREIGN KEY (`ref_moneytransfer_id`) REFERENCES `ac_moneytransfer` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_transactions_ibfk_6` FOREIGN KEY (`ref_moneydeposits_id`) REFERENCES `ac_moneydeposits` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_transactions_ibfk_7` FOREIGN KEY (`customer_id`) REFERENCES `db_customers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_transactions_ibfk_8` FOREIGN KEY (`ref_salespayments_id`) REFERENCES `db_salespayments` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `ac_transactions_ibfk_9` FOREIGN KEY (`ref_salespaymentsreturn_id`) REFERENCES `db_salespaymentsreturn` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=836 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `ac_transactions` (`id`, `store_id`, `payment_code`, `transaction_date`, `transaction_type`, `debit_account_id`, `credit_account_id`, `debit_amt`, `credit_amt`, `note`, `created_by`, `created_date`, `ref_accounts_id`, `ref_moneytransfer_id`, `ref_moneydeposits_id`, `ref_salespayments_id`, `ref_salespaymentsreturn_id`, `ref_purchasepayments_id`, `ref_purchasepaymentsreturn_id`, `ref_expense_id`, `customer_id`, `supplier_id`, `short_code`) VALUES (830, 2, '', '2024-07-09', 'OPENING BALANCE', NULL, 1, NULL, '5000.0000', '', 'user_67930', '2024-07-09', 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `ac_transactions` (`id`, `store_id`, `payment_code`, `transaction_date`, `transaction_type`, `debit_account_id`, `credit_account_id`, `debit_amt`, `credit_amt`, `note`, `created_by`, `created_date`, `ref_accounts_id`, `ref_moneytransfer_id`, `ref_moneydeposits_id`, `ref_salespayments_id`, `ref_salespaymentsreturn_id`, `ref_purchasepayments_id`, `ref_purchasepaymentsreturn_id`, `ref_expense_id`, `customer_id`, `supplier_id`, `short_code`) VALUES (831, 2, '', '2024-07-09', 'OPENING BALANCE', NULL, 2, NULL, '500.0000', '', 'user_67930', '2024-07-09', 2, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `ac_transactions` (`id`, `store_id`, `payment_code`, `transaction_date`, `transaction_type`, `debit_account_id`, `credit_account_id`, `debit_amt`, `credit_amt`, `note`, `created_by`, `created_date`, `ref_accounts_id`, `ref_moneytransfer_id`, `ref_moneydeposits_id`, `ref_salespayments_id`, `ref_salespaymentsreturn_id`, `ref_purchasepayments_id`, `ref_purchasepaymentsreturn_id`, `ref_expense_id`, `customer_id`, `supplier_id`, `short_code`) VALUES (832, 2, '', '2024-07-09', 'OPENING BALANCE', NULL, 3, NULL, '108.0000', '', 'user_67930', '2024-07-09', 3, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `ac_transactions` (`id`, `store_id`, `payment_code`, `transaction_date`, `transaction_type`, `debit_account_id`, `credit_account_id`, `debit_amt`, `credit_amt`, `note`, `created_by`, `created_date`, `ref_accounts_id`, `ref_moneytransfer_id`, `ref_moneydeposits_id`, `ref_salespayments_id`, `ref_salespaymentsreturn_id`, `ref_purchasepayments_id`, `ref_purchasepaymentsreturn_id`, `ref_expense_id`, `customer_id`, `supplier_id`, `short_code`) VALUES (833, 2, '', '2024-07-09', 'OPENING BALANCE', NULL, 4, NULL, '0.0000', '', 'user_67930', '2024-07-09', 4, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `ac_transactions` (`id`, `store_id`, `payment_code`, `transaction_date`, `transaction_type`, `debit_account_id`, `credit_account_id`, `debit_amt`, `credit_amt`, `note`, `created_by`, `created_date`, `ref_accounts_id`, `ref_moneytransfer_id`, `ref_moneydeposits_id`, `ref_salespayments_id`, `ref_salespaymentsreturn_id`, `ref_purchasepayments_id`, `ref_purchasepaymentsreturn_id`, `ref_expense_id`, `customer_id`, `supplier_id`, `short_code`) VALUES (834, 2, '', '2024-07-09', 'OPENING BALANCE', NULL, 5, NULL, '0.0000', '', 'user_67930', '2024-07-09', 5, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
INSERT INTO `ac_transactions` (`id`, `store_id`, `payment_code`, `transaction_date`, `transaction_type`, `debit_account_id`, `credit_account_id`, `debit_amt`, `credit_amt`, `note`, `created_by`, `created_date`, `ref_accounts_id`, `ref_moneytransfer_id`, `ref_moneydeposits_id`, `ref_salespayments_id`, `ref_salespaymentsreturn_id`, `ref_purchasepayments_id`, `ref_purchasepaymentsreturn_id`, `ref_expense_id`, `customer_id`, `supplier_id`, `short_code`) VALUES (835, 2, '', '2024-07-09', 'OPENING BALANCE', NULL, 6, NULL, '0.0000', '', 'user_67930', '2024-07-09', 6, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);


#
# TABLE STRUCTURE FOR: ci_sessions
#

DROP TABLE IF EXISTS `ci_sessions`;

CREATE TABLE `ci_sessions` (
  `id` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `ip_address` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `timestamp` int(10) unsigned NOT NULL DEFAULT 0,
  `data` blob NOT NULL,
  KEY `ci_sessions_timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('q2qp5k2ds29v909odv647s4llcou0c6g', '::1', 1720454403, '__ci_last_regenerate|i:1720454403;language|s:7:\"English\";currency|s:0:\"\";currency_placement|s:0:\"\";currency_code|s:0:\"\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"2\";qty_decimals|s:1:\"2\";store_name|s:10:\"SAAS ADMIN\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6ucc7nbbh699iij4otha94jmdtu8u77d', '::1', 1720454712, '__ci_last_regenerate|i:1720454712;language|s:7:\"English\";currency|s:0:\"\";currency_placement|s:0:\"\";currency_code|s:0:\"\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"2\";qty_decimals|s:1:\"2\";store_name|s:10:\"SAAS ADMIN\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('nikcdnnrtlfequv9sq1af5ikeuneekpm', '::1', 1720455172, '__ci_last_regenerate|i:1720455172;language|s:7:\"English\";currency|s:0:\"\";currency_placement|s:0:\"\";currency_code|s:0:\"\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"2\";qty_decimals|s:1:\"2\";store_name|s:10:\"SAAS ADMIN\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('jlv5jimc230hbtcg9bi4f4ilprie1gph', '::1', 1720455553, '__ci_last_regenerate|i:1720455553;language|s:7:\"English\";currency|s:0:\"\";currency_placement|s:0:\"\";currency_code|s:0:\"\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"2\";qty_decimals|s:1:\"2\";store_name|s:10:\"SAAS ADMIN\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('6ru9l3o0vc2oar18173bbhiaf8sma8hs', '::1', 1720455866, '__ci_last_regenerate|i:1720455866;language|s:7:\"English\";currency|s:0:\"\";currency_placement|s:0:\"\";currency_code|s:0:\"\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"2\";qty_decimals|s:1:\"2\";store_name|s:10:\"SAAS ADMIN\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('ka60eturvgk7h9c7nkm43um38lg09oej', '::1', 1720456197, '__ci_last_regenerate|i:1720456197;language|s:7:\"English\";currency|s:0:\"\";currency_placement|s:0:\"\";currency_code|s:0:\"\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"2\";qty_decimals|s:1:\"2\";store_name|s:10:\"SAAS ADMIN\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('h0brd567q2604rs4e5c5bssb4paode36', '::1', 1720456677, '__ci_last_regenerate|i:1720456677;language|s:7:\"English\";currency|s:0:\"\";currency_placement|s:0:\"\";currency_code|s:0:\"\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"2\";qty_decimals|s:1:\"2\";store_name|s:10:\"SAAS ADMIN\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('85msvh4vho4pqq2ik1t1jvi0gsvvvnng', '::1', 1720457020, '__ci_last_regenerate|i:1720457020;language|s:7:\"English\";currency|s:0:\"\";currency_placement|s:0:\"\";currency_code|s:0:\"\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"2\";qty_decimals|s:1:\"2\";store_name|s:10:\"SAAS ADMIN\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('lo28msm145ad87igookrfe61918vsikk', '::1', 1720457410, '__ci_last_regenerate|i:1720457410;language|s:7:\"English\";currency|s:0:\"\";currency_placement|s:0:\"\";currency_code|s:0:\"\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"2\";qty_decimals|s:1:\"2\";store_name|s:10:\"SAAS ADMIN\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('8hto0n9d7p3oaou5s8dfvnaqgv37aua6', '::1', 1720457791, '__ci_last_regenerate|i:1720457791;language|s:7:\"English\";currency|s:0:\"\";currency_placement|s:0:\"\";currency_code|s:0:\"\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"2\";qty_decimals|s:1:\"2\";store_name|s:10:\"SAAS ADMIN\";failed|s:30:\"Please Enter Email & password!\";__ci_vars|a:1:{s:6:\"failed\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('82bosicoh6ttqj5uipm427t883gscdcm', '::1', 1720462064, '__ci_last_regenerate|i:1720462064;language|s:7:\"English\";currency|s:0:\"\";currency_placement|s:0:\"\";currency_code|s:0:\"\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"2\";qty_decimals|s:1:\"2\";store_name|s:10:\"SAAS ADMIN\";success|s:58:\"OTP has been sent to your email ID! (Check Inbox/Spam Box)\";__ci_vars|a:1:{s:7:\"success\";s:3:\"old\";}email|s:29:\"info.elitedesignsbd@gmail.com\";otp|i:3076;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('mdv6hi5bu9ghfuvvildah9gorfbn27jo', '::1', 1720458545, '__ci_last_regenerate|i:1720458545;currency|s:0:\"\";currency_placement|s:0:\"\";currency_code|s:0:\"\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"2\";qty_decimals|s:1:\"2\";store_name|s:10:\"SAAS ADMIN\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('fb6o8soi8ho3njficc0tcoreiup0bui1', '::1', 1720458905, '__ci_last_regenerate|i:1720458905;currency|s:0:\"\";currency_placement|s:0:\"\";currency_code|s:0:\"\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"2\";qty_decimals|s:1:\"2\";store_name|s:10:\"SAAS ADMIN\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('p30aavpvf2c7sr9f7o3ufdvh6kbqspej', '::1', 1720459228, '__ci_last_regenerate|i:1720459228;currency|s:0:\"\";currency_placement|s:0:\"\";currency_code|s:0:\"\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"2\";qty_decimals|s:1:\"2\";store_name|s:10:\"SAAS ADMIN\";email|s:29:\"info.elitedesignsbd@gmail.com\";otp|i:1325;failed|s:13:\"Invalid OTP!!\";__ci_vars|a:1:{s:6:\"failed\";s:3:\"old\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('skuqbrv878736h6r2827q5fig4bc8r5g', '::1', 1720459594, '__ci_last_regenerate|i:1720459594;currency|s:0:\"\";currency_placement|s:0:\"\";currency_code|s:0:\"\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"2\";qty_decimals|s:1:\"2\";store_name|s:10:\"SAAS ADMIN\";email|s:29:\"info.elitedesignsbd@gmail.com\";otp|i:1325;');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('9s2rugq5b3c3k0q5pgct85lv2n23p68k', '::1', 1720460104, '__ci_last_regenerate|i:1720460104;language|s:7:\"English\";currency|s:6:\"ر.ع.\";currency_placement|s:4:\"Left\";currency_code|s:3:\"OMR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"3\";qty_decimals|s:1:\"2\";store_name|s:17:\"Home Care Trading\";email|s:29:\"info.elitedesignsbd@gmail.com\";otp|i:5242;inv_username|s:10:\"user_67930\";user_lname|s:6:\"Morris\";inv_userid|s:1:\"2\";logged_in|b:1;role_id|s:1:\"2\";role_name|s:11:\"Store Admin\";store_id|s:1:\"2\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('04t0afp7na721vdu0vf9ml6n4rtmvtto', '::1', 1720460434, '__ci_last_regenerate|i:1720460434;language|s:7:\"English\";currency|s:6:\"ر.ع.\";currency_placement|s:4:\"Left\";currency_code|s:3:\"OMR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"3\";qty_decimals|s:1:\"2\";store_name|s:17:\"Home Care Trading\";email|s:29:\"info.elitedesignsbd@gmail.com\";otp|i:5242;inv_username|s:10:\"user_67930\";user_lname|s:6:\"Morris\";inv_userid|s:1:\"2\";logged_in|b:1;role_id|s:1:\"2\";role_name|s:11:\"Store Admin\";store_id|s:1:\"2\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('fg056f273huk6ids1qsrjb3dlgfhduij', '::1', 1720460743, '__ci_last_regenerate|i:1720460743;language|s:7:\"English\";currency|s:6:\"ر.ع.\";currency_placement|s:4:\"Left\";currency_code|s:3:\"OMR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"3\";qty_decimals|s:1:\"2\";store_name|s:17:\"Home Care Trading\";email|s:29:\"info.elitedesignsbd@gmail.com\";otp|i:5242;inv_username|s:10:\"user_67930\";user_lname|s:6:\"Morris\";inv_userid|s:1:\"2\";logged_in|b:1;role_id|s:1:\"2\";role_name|s:11:\"Store Admin\";store_id|s:1:\"2\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('4tj1etqdm2kdch45fia7dovckf1bsqeb', '::1', 1720461047, '__ci_last_regenerate|i:1720461047;language|s:7:\"English\";currency|s:6:\"ر.ع.\";currency_placement|s:4:\"Left\";currency_code|s:3:\"OMR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"3\";qty_decimals|s:1:\"2\";store_name|s:17:\"Home Care Trading\";email|s:29:\"info.elitedesignsbd@gmail.com\";otp|i:5242;inv_username|s:10:\"user_67930\";user_lname|s:6:\"Morris\";inv_userid|s:1:\"2\";logged_in|b:1;role_id|s:1:\"2\";role_name|s:11:\"Store Admin\";store_id|s:1:\"2\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('64rntju7lc85gah9rkenkh13c2kvs1t7', '::1', 1720461373, '__ci_last_regenerate|i:1720461373;language|s:7:\"English\";currency|s:6:\"ر.ع.\";currency_placement|s:4:\"Left\";currency_code|s:3:\"OMR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"3\";qty_decimals|s:1:\"2\";store_name|s:17:\"Home Care Trading\";email|s:29:\"info.elitedesignsbd@gmail.com\";otp|i:5242;inv_username|s:10:\"user_67930\";user_lname|s:6:\"Morris\";inv_userid|s:1:\"2\";logged_in|b:1;role_id|s:1:\"2\";role_name|s:11:\"Store Admin\";store_id|s:1:\"2\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('1qg6qu7i0g8mt3bmvvr5021c40ndtst3', '::1', 1720461685, '__ci_last_regenerate|i:1720461685;language|s:7:\"English\";currency|s:6:\"ر.ع.\";currency_placement|s:4:\"Left\";currency_code|s:3:\"OMR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"3\";qty_decimals|s:1:\"2\";store_name|s:17:\"Home Care Trading\";email|s:29:\"info.elitedesignsbd@gmail.com\";otp|i:5242;inv_username|s:10:\"user_67930\";user_lname|s:6:\"Morris\";inv_userid|s:1:\"2\";logged_in|b:1;role_id|s:1:\"2\";role_name|s:11:\"Store Admin\";store_id|s:1:\"2\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('me74rbhvpq5tkqahi19ngc3o3ci5d69t', '::1', 1720461989, '__ci_last_regenerate|i:1720461989;language|s:7:\"English\";currency|s:6:\"ر.ع.\";currency_placement|s:4:\"Left\";currency_code|s:3:\"OMR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"3\";qty_decimals|s:1:\"2\";store_name|s:17:\"Home Care Trading\";email|s:29:\"info.elitedesignsbd@gmail.com\";otp|i:5242;inv_username|s:10:\"user_67930\";user_lname|s:6:\"Morris\";inv_userid|s:1:\"2\";logged_in|b:1;role_id|s:1:\"2\";role_name|s:11:\"Store Admin\";store_id|s:1:\"2\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('unpjbacc56tnlnoa6ua54ksvfgksosdd', '::1', 1720462045, '__ci_last_regenerate|i:1720461989;language|s:7:\"English\";currency|s:6:\"ر.ع.\";currency_placement|s:4:\"Left\";currency_code|s:3:\"OMR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"3\";qty_decimals|s:1:\"2\";store_name|s:17:\"Home Care Trading\";email|s:29:\"info.elitedesignsbd@gmail.com\";otp|i:5242;inv_username|s:10:\"user_67930\";user_lname|s:6:\"Morris\";inv_userid|s:1:\"2\";logged_in|b:1;role_id|s:1:\"2\";role_name|s:11:\"Store Admin\";store_id|s:1:\"2\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('afk3oit1djue6gi438iibn5hgs4q2tan', '::1', 1720462460, '__ci_last_regenerate|i:1720462460;language|s:7:\"English\";currency|s:6:\"ر.ع.\";currency_placement|s:4:\"Left\";currency_code|s:3:\"OMR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"3\";qty_decimals|s:1:\"2\";store_name|s:17:\"Home Care Trading\";email|s:29:\"info.elitedesignsbd@gmail.com\";otp|i:3076;inv_username|s:10:\"user_67930\";user_lname|s:6:\"Morris\";inv_userid|s:1:\"2\";logged_in|b:1;role_id|s:1:\"2\";role_name|s:11:\"Store Admin\";store_id|s:1:\"2\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('jj9qdmqbpie9bnhla891038sqkue7nbj', '::1', 1720463018, '__ci_last_regenerate|i:1720463018;language|s:7:\"English\";currency|s:6:\"ر.ع.\";currency_placement|s:4:\"Left\";currency_code|s:3:\"OMR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"3\";qty_decimals|s:1:\"2\";store_name|s:17:\"Home Care Trading\";email|s:29:\"info.elitedesignsbd@gmail.com\";otp|i:3076;inv_username|s:10:\"user_67930\";user_lname|s:6:\"Morris\";inv_userid|s:1:\"2\";logged_in|b:1;role_id|s:1:\"2\";role_name|s:11:\"Store Admin\";store_id|s:1:\"2\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('q3fmp1n24oqqbcbvrqn7eht04fpced6b', '::1', 1720463347, '__ci_last_regenerate|i:1720463347;language|s:7:\"English\";currency|s:6:\"ر.ع.\";currency_placement|s:4:\"Left\";currency_code|s:3:\"OMR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"3\";qty_decimals|s:1:\"2\";store_name|s:17:\"Home Care Trading\";email|s:29:\"info.elitedesignsbd@gmail.com\";otp|i:3076;inv_username|s:10:\"user_67930\";user_lname|s:6:\"Morris\";inv_userid|s:1:\"2\";logged_in|b:1;role_id|s:1:\"2\";role_name|s:11:\"Store Admin\";store_id|s:1:\"2\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('j4p5rgr2cmqbuigvalkm943h58eb0ikm', '::1', 1720463662, '__ci_last_regenerate|i:1720463662;language|s:7:\"English\";currency|s:6:\"ر.ع.\";currency_placement|s:4:\"Left\";currency_code|s:3:\"OMR\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"3\";qty_decimals|s:1:\"2\";store_name|s:17:\"Home Care Trading\";email|s:29:\"info.elitedesignsbd@gmail.com\";otp|i:3076;inv_username|s:10:\"user_67930\";user_lname|s:6:\"Morris\";inv_userid|s:1:\"2\";logged_in|b:1;role_id|s:1:\"2\";role_name|s:11:\"Store Admin\";store_id|s:1:\"2\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('0n38sm05jqjlbvmitrfoasgcj50o7ami', '::1', 1720463993, '__ci_last_regenerate|i:1720463993;language|s:7:\"English\";currency|N;currency_placement|N;currency_code|N;view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"3\";qty_decimals|s:1:\"2\";store_name|s:17:\"Home Care Trading\";email|s:29:\"info.elitedesignsbd@gmail.com\";otp|i:3076;inv_username|s:10:\"user_67930\";user_lname|s:6:\"Morris\";inv_userid|s:1:\"2\";logged_in|b:1;role_id|s:1:\"2\";role_name|s:11:\"Store Admin\";store_id|s:1:\"2\";success|s:36:\"Success!! User Updated Succssfully!!\";__ci_vars|a:1:{s:7:\"success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('s5ae6l2qib9kviij4af6s4f2p3g0d5td', '::1', 1720464491, '__ci_last_regenerate|i:1720464491;language|s:7:\"English\";currency_placement|N;currency_code|N;view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"3\";qty_decimals|s:1:\"2\";store_name|s:17:\"Home Care Trading\";email|s:29:\"info.elitedesignsbd@gmail.com\";otp|i:3076;inv_username|s:10:\"user_67930\";user_lname|s:6:\"Morris\";inv_userid|s:1:\"2\";logged_in|b:1;role_id|s:1:\"2\";role_name|s:11:\"Store Admin\";store_id|s:1:\"2\";');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('5dflr7fcu7k0nq2o28990s0lrlcouf19', '::1', 1720464797, '__ci_last_regenerate|i:1720464797;language|s:7:\"English\";currency_placement|s:4:\"Left\";currency_code|s:3:\"BDT\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"3\";qty_decimals|s:1:\"2\";store_name|s:21:\"AR Departmental Store\";email|s:29:\"info.elitedesignsbd@gmail.com\";otp|i:3076;inv_username|s:10:\"user_67930\";user_lname|s:6:\"Morris\";inv_userid|s:1:\"2\";logged_in|b:1;role_id|s:1:\"2\";role_name|s:11:\"Store Admin\";store_id|s:1:\"2\";currency|s:2:\"TK\";success|s:36:\"Success!! Record Added Successfully!\";__ci_vars|a:1:{s:7:\"success\";s:3:\"new\";}');
INSERT INTO `ci_sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('mso5phv58ar5k3i6276o22qh8jvc6qvr', '::1', 1720465070, '__ci_last_regenerate|i:1720464797;language|s:7:\"English\";currency_placement|s:4:\"Left\";currency_code|s:3:\"BDT\";view_date|s:10:\"dd-mm-yyyy\";view_time|s:2:\"12\";decimals|s:1:\"3\";qty_decimals|s:1:\"2\";store_name|s:21:\"AR Departmental Store\";email|s:29:\"info.elitedesignsbd@gmail.com\";otp|i:3076;inv_username|s:10:\"user_67930\";user_lname|s:6:\"Morris\";inv_userid|s:1:\"2\";logged_in|b:1;role_id|s:1:\"2\";role_name|s:11:\"Store Admin\";store_id|s:1:\"2\";currency|s:2:\"TK\";');


#
# TABLE STRUCTURE FOR: db_bankdetails
#

DROP TABLE IF EXISTS `db_bankdetails`;

CREATE TABLE `db_bankdetails` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `country_id` int(11) DEFAULT NULL,
  `holder_name` varchar(250) DEFAULT NULL,
  `bank_name` varchar(250) DEFAULT NULL,
  `branch_name` varchar(250) DEFAULT NULL,
  `code` varchar(250) DEFAULT NULL COMMENT 'IFSC or Bank Code',
  `account_type` varchar(250) DEFAULT NULL,
  `account_number` varchar(250) DEFAULT NULL,
  `other_details` mediumtext DEFAULT NULL,
  `description` mediumtext DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_bankdetails_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_bankdetails` (`id`, `store_id`, `country_id`, `holder_name`, `bank_name`, `branch_name`, `code`, `account_type`, `account_number`, `other_details`, `description`, `status`) VALUES (1, 1, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1);


#
# TABLE STRUCTURE FOR: db_brands
#

DROP TABLE IF EXISTS `db_brands`;

CREATE TABLE `db_brands` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `brand_code` varchar(50) DEFAULT NULL,
  `brand_name` varchar(100) DEFAULT NULL,
  `description` mediumtext DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_brands_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_brands_ibfk_2` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=327 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_category
#

DROP TABLE IF EXISTS `db_category`;

CREATE TABLE `db_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `count_id` int(11) DEFAULT NULL COMMENT 'Use to create category Code',
  `category_code` varchar(50) DEFAULT NULL,
  `category_name` varchar(100) DEFAULT NULL,
  `description` mediumtext DEFAULT NULL,
  `company_id` int(11) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_category_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=83 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_category` (`id`, `store_id`, `count_id`, `category_code`, `category_name`, `description`, `company_id`, `status`) VALUES (82, 2, 1, 'CT/02/0001', 'Electronics', '', NULL, 1);


#
# TABLE STRUCTURE FOR: db_cobpayments
#

DROP TABLE IF EXISTS `db_cobpayments`;

CREATE TABLE `db_cobpayments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `customer_id` int(11) DEFAULT NULL,
  `payment_date` date DEFAULT NULL,
  `payment_type` varchar(50) DEFAULT NULL,
  `payment` double(10,2) DEFAULT NULL,
  `payment_note` mediumtext DEFAULT NULL,
  `system_ip` varchar(50) DEFAULT NULL,
  `system_name` varchar(50) DEFAULT NULL,
  `created_time` time DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_by` varchar(50) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_company
#

DROP TABLE IF EXISTS `db_company`;

CREATE TABLE `db_company` (
  `id` double DEFAULT NULL,
  `company_code` varchar(150) DEFAULT NULL,
  `company_name` varchar(150) DEFAULT NULL,
  `company_website` varchar(150) DEFAULT NULL,
  `mobile` varchar(150) DEFAULT NULL,
  `phone` varchar(150) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `website` varchar(250) DEFAULT NULL,
  `company_logo` text DEFAULT NULL,
  `logo` mediumtext DEFAULT NULL,
  `upi_id` varchar(50) DEFAULT NULL,
  `upi_code` text DEFAULT NULL,
  `country` varchar(150) DEFAULT NULL,
  `state` varchar(150) DEFAULT NULL,
  `city` varchar(100) DEFAULT NULL,
  `address` varchar(300) DEFAULT NULL,
  `postcode` varchar(50) DEFAULT NULL,
  `gst_no` varchar(50) DEFAULT NULL,
  `vat_no` varchar(50) DEFAULT NULL,
  `pan_no` varchar(50) DEFAULT NULL,
  `bank_details` mediumtext DEFAULT NULL,
  `cid` int(11) DEFAULT NULL,
  `category_init` varchar(5) DEFAULT NULL,
  `item_init` varchar(5) DEFAULT NULL COMMENT 'INITAL CODE',
  `supplier_init` varchar(5) DEFAULT NULL COMMENT 'INITAL CODE',
  `purchase_init` varchar(5) DEFAULT NULL COMMENT 'INITAL CODE',
  `purchase_return_init` varchar(5) DEFAULT NULL,
  `customer_init` varchar(5) DEFAULT NULL COMMENT 'INITAL CODE',
  `sales_init` varchar(5) DEFAULT NULL COMMENT 'INITAL CODE',
  `sales_return_init` varchar(5) DEFAULT NULL,
  `expense_init` varchar(5) DEFAULT NULL,
  `invoice_view` int(11) DEFAULT NULL COMMENT '1=Standard,2=Indian GST',
  `status` int(11) DEFAULT NULL,
  `sms_status` int(11) DEFAULT NULL COMMENT '1=Enable 0=Disable',
  `sales_terms_and_conditions` text DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_company` (`id`, `company_code`, `company_name`, `company_website`, `mobile`, `phone`, `email`, `website`, `company_logo`, `logo`, `upi_id`, `upi_code`, `country`, `state`, `city`, `address`, `postcode`, `gst_no`, `vat_no`, `pan_no`, `bank_details`, `cid`, `category_init`, `item_init`, `supplier_init`, `purchase_init`, `purchase_return_init`, `customer_init`, `sales_init`, `sales_return_init`, `expense_init`, `invoice_view`, `status`, `sms_status`, `sales_terms_and_conditions`) VALUES ('1', '', 'Company Name', NULL, '9999999999', '', 'admin@example.com', '', 'company_logo.png', 'logo-0.png', NULL, NULL, 'India', 'Karnataka', 'Belgaum', 'Address Details', '', '', '', '', '', 1, 'CT', 'IT', 'SP', 'PU', 'PR', 'CU', 'SL', 'PR', 'EX', 1, 1, 0, NULL);


#
# TABLE STRUCTURE FOR: db_country
#

DROP TABLE IF EXISTS `db_country`;

CREATE TABLE `db_country` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `country` varchar(4050) DEFAULT NULL,
  `added_on` date DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=211 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_country` (`id`, `country`, `added_on`, `status`) VALUES (210, 'Bangladesh', NULL, 1);


#
# TABLE STRUCTURE FOR: db_coupons
#

DROP TABLE IF EXISTS `db_coupons`;

CREATE TABLE `db_coupons` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `code` varchar(50) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `value` double(20,2) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `expire_date` date DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `created_by` varchar(100) DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(100) DEFAULT NULL,
  `system_name` varchar(250) DEFAULT NULL,
  `system_ip` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_coupons_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_coupons_ibfk_2` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=343 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_currency
#

DROP TABLE IF EXISTS `db_currency`;

CREATE TABLE `db_currency` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `currency_name` varchar(50) DEFAULT NULL,
  `currency_code` varchar(20) DEFAULT NULL,
  `currency` blob DEFAULT NULL,
  `symbol` mediumtext DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=61 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_currency` (`id`, `currency_name`, `currency_code`, `currency`, `symbol`, `status`) VALUES (60, 'TAKA', 'BDT', 'TK', NULL, 1);


#
# TABLE STRUCTURE FOR: db_custadvance
#

DROP TABLE IF EXISTS `db_custadvance`;

CREATE TABLE `db_custadvance` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `count_id` int(11) DEFAULT NULL,
  `payment_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `payment_date` date DEFAULT NULL,
  `customer_id` int(11) DEFAULT NULL,
  `amount` double(20,4) DEFAULT NULL,
  `payment_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `system_ip` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `system_name` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_custadvance_ibfk_1` FOREIGN KEY (`customer_id`) REFERENCES `db_customers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_custadvance_ibfk_2` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_customer_coupons
#

DROP TABLE IF EXISTS `db_customer_coupons`;

CREATE TABLE `db_customer_coupons` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `code` varchar(50) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `value` double(20,2) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `expire_date` date DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `created_by` varchar(100) DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(100) DEFAULT NULL,
  `system_name` varchar(250) DEFAULT NULL,
  `system_ip` varchar(250) DEFAULT NULL,
  `customer_id` int(11) DEFAULT NULL,
  `coupon_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `customer_id` (`customer_id`),
  KEY `coupon_id` (`coupon_id`),
  CONSTRAINT `db_customer_coupons_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_customer_coupons_ibfk_2` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_customer_coupons_ibfk_3` FOREIGN KEY (`customer_id`) REFERENCES `db_customers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_customer_coupons_ibfk_4` FOREIGN KEY (`coupon_id`) REFERENCES `db_coupons` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_customer_payments
#

DROP TABLE IF EXISTS `db_customer_payments`;

CREATE TABLE `db_customer_payments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `salespayment_id` int(11) DEFAULT NULL,
  `customer_id` int(11) DEFAULT NULL,
  `payment_date` date DEFAULT NULL,
  `payment_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `payment` double(10,2) DEFAULT NULL,
  `payment_note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `system_ip` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `system_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_date` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_id` (`customer_id`),
  KEY `salespayment_id` (`salespayment_id`),
  CONSTRAINT `db_customer_payments_ibfk_1` FOREIGN KEY (`customer_id`) REFERENCES `db_customers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_customer_payments_ibfk_2` FOREIGN KEY (`salespayment_id`) REFERENCES `db_salespayments` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_customers
#

DROP TABLE IF EXISTS `db_customers`;

CREATE TABLE `db_customers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `count_id` int(11) DEFAULT NULL COMMENT 'Use to create Customer Code',
  `customer_code` varchar(20) DEFAULT NULL,
  `customer_name` varchar(50) DEFAULT NULL,
  `mobile` varchar(15) DEFAULT NULL,
  `phone` varchar(15) DEFAULT NULL,
  `email` varchar(50) DEFAULT NULL,
  `gstin` varchar(100) DEFAULT NULL,
  `tax_number` varchar(50) DEFAULT NULL,
  `vatin` varchar(100) DEFAULT NULL,
  `opening_balance` double(20,4) DEFAULT NULL,
  `sales_due` double(20,4) DEFAULT NULL,
  `sales_return_due` double(20,4) DEFAULT NULL,
  `country_id` int(11) DEFAULT NULL,
  `state_id` int(11) DEFAULT NULL,
  `city` varchar(50) DEFAULT NULL,
  `postcode` varchar(10) DEFAULT NULL,
  `address` varchar(250) DEFAULT NULL,
  `ship_country_id` int(11) DEFAULT NULL,
  `ship_state_id` int(11) DEFAULT NULL,
  `ship_city` varchar(100) DEFAULT NULL,
  `ship_postcode` varchar(10) DEFAULT NULL,
  `ship_address` text DEFAULT NULL,
  `system_ip` varchar(50) DEFAULT NULL,
  `system_name` varchar(50) DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(30) DEFAULT NULL,
  `created_by` varchar(50) DEFAULT NULL,
  `company_id` int(11) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `location_link` text DEFAULT NULL,
  `attachment_1` text DEFAULT NULL,
  `price_level_type` varchar(50) DEFAULT 'Increase',
  `price_level` double(20,4) DEFAULT 0.0000,
  `delete_bit` int(11) DEFAULT 0,
  `tot_advance` double(20,4) DEFAULT NULL,
  `credit_limit` double(20,4) DEFAULT -1.0000,
  `shippingaddress_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_customers_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`) VALUES (1, 1, NULL, 'CU0001', 'Walk-in customer', NULL, '', '', '', '', NULL, '0.0000', '0.0000', '0.0000', 1, NULL, NULL, '', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2019-01-01', '10:55:54 pm', 'admin', NULL, 1, NULL, NULL, 'Increase', '0.0000', 1, NULL, '-1.0000', 1);
INSERT INTO `db_customers` (`id`, `store_id`, `count_id`, `customer_code`, `customer_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `sales_due`, `sales_return_due`, `country_id`, `state_id`, `city`, `postcode`, `address`, `ship_country_id`, `ship_state_id`, `ship_city`, `ship_postcode`, `ship_address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`, `location_link`, `attachment_1`, `price_level_type`, `price_level`, `delete_bit`, `tot_advance`, `credit_limit`, `shippingaddress_id`) VALUES (2, 2, 1, 'CU/02/0001', 'Walk-in customer', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '0.6000', '0.0000', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '127.0.0.1', 'LAPTOP-I5OUIM4R', '2021-02-12', '05:53:37 pm', '', NULL, 1, NULL, NULL, 'Increase', '0.0000', 1, '0.0000', '-1.0000', 2);


#
# TABLE STRUCTURE FOR: db_emailtemplates
#

DROP TABLE IF EXISTS `db_emailtemplates`;

CREATE TABLE `db_emailtemplates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `key` varchar(150) DEFAULT NULL,
  `template_name` varchar(100) DEFAULT NULL,
  `content` text DEFAULT NULL,
  `variables` text DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `undelete_bit` int(11) DEFAULT NULL,
  `admin_only` int(11) DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_emailtemplates_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_emailtemplates` (`id`, `store_id`, `key`, `template_name`, `content`, `variables`, `status`, `undelete_bit`, `admin_only`) VALUES (1, 1, 'SAAS_FORGOT_PASSWORD_EMAIL', 'Site forgot password email template', 'Hi {{user_name}},\r\n\r\nyour OTP is {{email_otp}}\r\n\r\nThank you\r\n{{saas_name}}', '{{user_name}}<br>\r\n{{saas_name}}<br>\r\n{{email_otp}}<br>', 1, 1, 1);
INSERT INTO `db_emailtemplates` (`id`, `store_id`, `key`, `template_name`, `content`, `variables`, `status`, `undelete_bit`, `admin_only`) VALUES (2, 1, 'SAAS_WELCOME_EMAIL', 'Site welcome email', 'Hi {{user_name}},\r\nYour email id {{email_id}},\r\nwelcome to our {{saas_name}},\r\n\r\nThank you', '{{user_name}}<br>\r\n{{email_id}}<br>\r\n{{saas_name}}<br>', 1, 1, 1);


#
# TABLE STRUCTURE FOR: db_expense
#

DROP TABLE IF EXISTS `db_expense`;

CREATE TABLE `db_expense` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `count_id` int(11) DEFAULT NULL COMMENT 'Use to create Expense Code',
  `expense_code` varchar(50) DEFAULT NULL,
  `category_id` int(11) DEFAULT NULL,
  `expense_date` date DEFAULT NULL,
  `reference_no` varchar(50) DEFAULT NULL,
  `expense_for` varchar(100) DEFAULT NULL,
  `expense_amt` double(20,4) DEFAULT NULL,
  `payment_type` varchar(100) DEFAULT NULL,
  `account_id` int(11) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `created_by` varchar(50) DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) DEFAULT NULL,
  `system_ip` varchar(50) DEFAULT NULL,
  `system_name` varchar(50) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `account_id` (`account_id`),
  CONSTRAINT `db_expense_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_expense_ibfk_2` FOREIGN KEY (`account_id`) REFERENCES `ac_accounts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_expense_category
#

DROP TABLE IF EXISTS `db_expense_category`;

CREATE TABLE `db_expense_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `category_code` varchar(50) DEFAULT NULL,
  `category_name` varchar(50) DEFAULT NULL,
  `description` mediumtext DEFAULT NULL,
  `created_by` varchar(50) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_expense_category_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=58 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_fivemojo
#

DROP TABLE IF EXISTS `db_fivemojo`;

CREATE TABLE `db_fivemojo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `url` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `token` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `instance_id` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `status` int(11) DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_fivemojo_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_fivemojo` (`id`, `store_id`, `url`, `token`, `instance_id`, `status`) VALUES (4, 2, 'https://app.fivemojo.com/api/send.php', '', '', 0);


#
# TABLE STRUCTURE FOR: db_hold
#

DROP TABLE IF EXISTS `db_hold`;

CREATE TABLE `db_hold` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `warehouse_id` int(11) DEFAULT NULL,
  `reference_id` varchar(50) DEFAULT NULL COMMENT 'Temprary',
  `reference_no` varchar(50) DEFAULT NULL,
  `sales_date` date DEFAULT NULL,
  `sales_status` varchar(50) DEFAULT NULL,
  `customer_id` int(11) DEFAULT NULL,
  `other_charges_input` double(20,2) DEFAULT NULL,
  `other_charges_tax_id` int(11) DEFAULT NULL,
  `other_charges_amt` double(20,2) DEFAULT NULL,
  `discount_to_all_input` double(20,2) DEFAULT NULL,
  `discount_to_all_type` varchar(50) DEFAULT NULL,
  `tot_discount_to_all_amt` double(20,2) DEFAULT NULL,
  `subtotal` double(20,2) DEFAULT NULL,
  `round_off` double(20,2) DEFAULT NULL,
  `grand_total` double(20,4) DEFAULT NULL,
  `sales_note` text DEFAULT NULL,
  `pos` int(11) DEFAULT NULL COMMENT '1=yes 0=no',
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `customer_id` (`customer_id`),
  KEY `warehouse_id` (`warehouse_id`),
  CONSTRAINT `db_hold_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_hold_ibfk_2` FOREIGN KEY (`customer_id`) REFERENCES `db_customers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_hold_ibfk_3` FOREIGN KEY (`warehouse_id`) REFERENCES `db_warehouse` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_holditems
#

DROP TABLE IF EXISTS `db_holditems`;

CREATE TABLE `db_holditems` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `hold_id` int(11) DEFAULT NULL,
  `item_id` int(11) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `sales_qty` double(20,2) DEFAULT NULL,
  `price_per_unit` double(20,4) DEFAULT NULL,
  `tax_type` varchar(50) DEFAULT NULL,
  `tax_id` int(11) DEFAULT NULL,
  `tax_amt` double(20,4) DEFAULT NULL,
  `discount_type` varchar(50) DEFAULT NULL,
  `discount_input` double(20,4) DEFAULT NULL,
  `discount_amt` double(20,4) DEFAULT NULL,
  `unit_total_cost` double(20,4) DEFAULT NULL,
  `total_cost` double(20,4) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `sales_id` (`hold_id`),
  KEY `item_id` (`item_id`),
  CONSTRAINT `db_holditems_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_holditems_ibfk_2` FOREIGN KEY (`hold_id`) REFERENCES `db_hold` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_holditems_ibfk_3` FOREIGN KEY (`item_id`) REFERENCES `db_items` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=394 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_instamojo
#

DROP TABLE IF EXISTS `db_instamojo`;

CREATE TABLE `db_instamojo` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `sandbox` int(11) DEFAULT NULL,
  `api_key` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `api_token` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `updated_at` date DEFAULT NULL,
  `updated_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_instamojo_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_instamojo` (`id`, `store_id`, `sandbox`, `api_key`, `api_token`, `updated_at`, `updated_by`, `status`) VALUES (1, 1, 1, '', '', '2021-02-22', 'Admin', 1);


#
# TABLE STRUCTURE FOR: db_instamojopayments
#

DROP TABLE IF EXISTS `db_instamojopayments`;

CREATE TABLE `db_instamojopayments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `phone` varchar(25) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `email` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `buyer_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `amount` decimal(16,2) NOT NULL,
  `purpose` text CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `expires_at` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `status` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `send_sms` varchar(5) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'false',
  `send_email` varchar(5) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'false',
  `sms_status` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `email_status` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `shorturl` mediumtext CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `longurl` mediumtext CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `redirect_url` mediumtext CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `webhook` mediumtext CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `allow_repeated_payments` varchar(5) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT 'false',
  `customer_id` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `created_at` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  `modified_at` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_items
#

DROP TABLE IF EXISTS `db_items`;

CREATE TABLE `db_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `count_id` int(11) DEFAULT NULL COMMENT 'Use to create ITEM Code',
  `item_code` varchar(50) DEFAULT NULL,
  `item_name` varchar(100) DEFAULT NULL,
  `category_id` int(11) DEFAULT NULL,
  `sku` varchar(50) DEFAULT NULL,
  `hsn` varchar(50) DEFAULT NULL,
  `sac` varchar(50) DEFAULT NULL,
  `unit_id` int(11) DEFAULT NULL,
  `alert_qty` int(11) DEFAULT NULL,
  `brand_id` int(11) DEFAULT NULL,
  `lot_number` varchar(50) DEFAULT NULL,
  `expire_date` date DEFAULT NULL,
  `price` double(20,4) DEFAULT NULL,
  `tax_id` int(11) DEFAULT NULL,
  `purchase_price` double(20,4) DEFAULT NULL,
  `tax_type` varchar(50) DEFAULT NULL,
  `profit_margin` double(20,2) DEFAULT NULL,
  `sales_price` double(20,4) DEFAULT NULL,
  `stock` double(20,2) DEFAULT NULL,
  `item_image` text DEFAULT NULL,
  `system_ip` varchar(50) DEFAULT NULL,
  `system_name` varchar(50) DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) DEFAULT NULL,
  `created_by` varchar(50) DEFAULT NULL,
  `company_id` int(11) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `discount_type` varchar(100) DEFAULT 'Percentage',
  `discount` double(20,2) DEFAULT 0.00,
  `service_bit` int(11) DEFAULT 0,
  `seller_points` double(20,2) DEFAULT 0.00,
  `custom_barcode` varchar(100) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `item_group` varchar(50) DEFAULT NULL,
  `parent_id` int(11) DEFAULT NULL,
  `variant_id` int(11) DEFAULT NULL,
  `child_bit` int(11) DEFAULT 0,
  `mrp` double(20,4) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_items_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_languages
#

DROP TABLE IF EXISTS `db_languages`;

CREATE TABLE `db_languages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `language` varchar(50) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_languages` (`id`, `language`, `status`) VALUES (1, 'English', 1);
INSERT INTO `db_languages` (`id`, `language`, `status`) VALUES (5, 'Bangla', 1);


#
# TABLE STRUCTURE FOR: db_package
#

DROP TABLE IF EXISTS `db_package`;

CREATE TABLE `db_package` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `package_type` varchar(50) DEFAULT NULL,
  `package_code` varchar(20) DEFAULT NULL,
  `package_name` varchar(50) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `monthly_price` double(20,2) DEFAULT NULL,
  `annual_price` double(20,2) DEFAULT NULL,
  `trial_days` int(11) DEFAULT NULL,
  `max_users` int(11) DEFAULT NULL,
  `max_items` int(11) DEFAULT NULL,
  `max_invoices` int(11) DEFAULT NULL,
  `max_warehouses` int(11) DEFAULT NULL,
  `expire_date` date DEFAULT NULL,
  `system_ip` varchar(50) DEFAULT NULL,
  `system_name` varchar(50) DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(30) DEFAULT NULL,
  `created_by` varchar(50) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `plan_type` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_package_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_package` (`id`, `store_id`, `package_type`, `package_code`, `package_name`, `description`, `monthly_price`, `annual_price`, `trial_days`, `max_users`, `max_items`, `max_invoices`, `max_warehouses`, `expire_date`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `status`, `plan_type`) VALUES (1, 1, 'Free', NULL, 'Free', 'Test description', '0.00', '0.00', 10, 2, 20, 20, 2, '2021-01-14', '127.0.0.1', 'LAPTOP-I5OUIM4R', '2021-01-13', '06:37:21 pm', 'admin', 1, NULL);
INSERT INTO `db_package` (`id`, `store_id`, `package_type`, `package_code`, `package_name`, `description`, `monthly_price`, `annual_price`, `trial_days`, `max_users`, `max_items`, `max_invoices`, `max_warehouses`, `expire_date`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `status`, `plan_type`) VALUES (2, 1, 'Paid', NULL, 'Regular', 'Test description', '250.00', '2000.00', 15, 20, 200, 200, 20, NULL, '127.0.0.1', 'LAPTOP-I5OUIM4R', '2021-01-13', '06:39:23 pm', 'admin', 1, NULL);
INSERT INTO `db_package` (`id`, `store_id`, `package_type`, `package_code`, `package_name`, `description`, `monthly_price`, `annual_price`, `trial_days`, `max_users`, `max_items`, `max_invoices`, `max_warehouses`, `expire_date`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `status`, `plan_type`) VALUES (3, 1, 'Paid', NULL, 'Ultimate', 'Description', '500.00', '5000.00', 15, -1, -1, -1, -1, NULL, '127.0.0.1', 'LAPTOP-I5OUIM4R', '2021-01-24', '12:35:30 pm', 'admin', 1, NULL);


#
# TABLE STRUCTURE FOR: db_paymenttypes
#

DROP TABLE IF EXISTS `db_paymenttypes`;

CREATE TABLE `db_paymenttypes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `payment_type` varchar(50) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_paymenttypes_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=37 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_paymenttypes` (`id`, `store_id`, `payment_type`, `status`) VALUES (36, 2, 'CASH', 1);


#
# TABLE STRUCTURE FOR: db_paypal
#

DROP TABLE IF EXISTS `db_paypal`;

CREATE TABLE `db_paypal` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `sandbox` int(11) DEFAULT NULL,
  `email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `updated_at` date DEFAULT NULL,
  `updated_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_paypal_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_paypal` (`id`, `store_id`, `sandbox`, `email`, `updated_at`, `updated_by`, `status`) VALUES (1, 1, 1, '', '2021-02-22', 'Admin', 1);


#
# TABLE STRUCTURE FOR: db_paypalpaylog
#

DROP TABLE IF EXISTS `db_paypalpaylog`;

CREATE TABLE `db_paypalpaylog` (
  `payment_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `txn_id` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `payment_gross` float(10,2) NOT NULL,
  `currency_code` varchar(5) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `payer_email` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `payment_status` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`payment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_permissions
#

DROP TABLE IF EXISTS `db_permissions`;

CREATE TABLE `db_permissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `role_id` int(11) DEFAULT NULL,
  `permissions` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_permissions_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6220 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4414, 1, 17, 'items_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4415, 1, 17, 'items_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4416, 1, 17, 'items_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4417, 1, 17, 'items_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4418, 1, 17, 'import_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4419, 1, 17, 'brand_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4420, 1, 17, 'brand_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4421, 1, 17, 'brand_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4422, 1, 17, 'brand_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4423, 1, 17, 'customers_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4424, 1, 17, 'customers_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4425, 1, 17, 'customers_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4426, 1, 17, 'customers_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4427, 1, 17, 'sales_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4428, 1, 17, 'sales_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4429, 1, 17, 'sales_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4430, 1, 17, 'sales_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4431, 1, 17, 'sales_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4432, 1, 17, 'sales_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4433, 1, 17, 'sales_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4434, 1, 17, 'sales_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4435, 1, 17, 'sales_payments_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4436, 1, 17, 'items_category_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4437, 1, 17, 'items_category_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4438, 1, 17, 'items_category_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4439, 1, 17, 'items_category_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4440, 1, 17, 'print_labels');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4441, 1, 17, 'dashboard_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4442, 1, 17, 'dashboard_info_box_1');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4443, 1, 17, 'dashboard_info_box_2');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4444, 1, 17, 'dashboard_pur_sal_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4445, 1, 17, 'dashboard_recent_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4446, 1, 17, 'dashboard_stock_alert');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4447, 1, 17, 'dashboard_trending_items_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4448, 1, 17, 'sales_return_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4449, 1, 17, 'sales_return_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4450, 1, 17, 'sales_return_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4451, 1, 17, 'sales_return_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4452, 1, 17, 'sales_return_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4453, 1, 17, 'sales_return_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4454, 1, 17, 'sales_return_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4455, 1, 17, 'sales_return_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4456, 1, 17, 'payment_types_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4457, 1, 17, 'payment_types_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4458, 1, 17, 'payment_types_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4459, 1, 17, 'payment_types_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4460, 1, 17, 'import_customers');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4461, 1, 17, 'stock_transfer_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4462, 1, 17, 'stock_transfer_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4463, 1, 17, 'stock_transfer_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4464, 1, 17, 'stock_transfer_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4465, 1, 17, 'seller_points_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4466, 1, 17, 'services_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4467, 1, 17, 'services_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4468, 1, 17, 'services_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4469, 1, 17, 'services_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4470, 1, 17, 'import_services');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4471, 1, 17, 'stock_adjustment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4472, 1, 17, 'stock_adjustment_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4473, 1, 17, 'stock_adjustment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4474, 1, 17, 'stock_adjustment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4475, 1, 17, 'variant_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4476, 1, 17, 'variant_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4477, 1, 17, 'variant_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4478, 1, 17, 'variant_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4479, 1, 17, 'accounts_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4480, 1, 17, 'accounts_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4481, 1, 17, 'accounts_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4482, 1, 17, 'accounts_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4483, 1, 17, 'money_transfer_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4484, 1, 17, 'money_transfer_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4485, 1, 17, 'money_transfer_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4486, 1, 17, 'money_transfer_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4487, 1, 17, 'money_deposit_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4488, 1, 17, 'money_deposit_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4489, 1, 17, 'money_deposit_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4490, 1, 17, 'money_deposit_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4491, 1, 17, 'sales_tax_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4492, 1, 18, 'tax_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4493, 1, 18, 'tax_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4494, 1, 18, 'tax_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4495, 1, 18, 'tax_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4496, 1, 18, 'units_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4497, 1, 18, 'units_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4498, 1, 18, 'units_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4499, 1, 18, 'units_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4500, 1, 18, 'items_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4501, 1, 18, 'items_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4502, 1, 18, 'items_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4503, 1, 18, 'items_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4504, 1, 18, 'import_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4505, 1, 18, 'brand_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4506, 1, 18, 'brand_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4507, 1, 18, 'brand_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4508, 1, 18, 'brand_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4509, 1, 18, 'suppliers_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4510, 1, 18, 'suppliers_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4511, 1, 18, 'suppliers_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4512, 1, 18, 'suppliers_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4513, 1, 18, 'purchase_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4514, 1, 18, 'purchase_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4515, 1, 18, 'purchase_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4516, 1, 18, 'purchase_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4517, 1, 18, 'purchase_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4518, 1, 18, 'purchase_payments_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4519, 1, 18, 'items_category_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4520, 1, 18, 'items_category_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4521, 1, 18, 'items_category_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4522, 1, 18, 'items_category_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4523, 1, 18, 'print_labels');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4524, 1, 18, 'dashboard_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4525, 1, 18, 'dashboard_info_box_1');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4526, 1, 18, 'dashboard_info_box_2');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4527, 1, 18, 'dashboard_pur_sal_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4528, 1, 18, 'dashboard_recent_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4529, 1, 18, 'dashboard_stock_alert');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4530, 1, 18, 'dashboard_trending_items_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4531, 1, 18, 'purchase_return_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4532, 1, 18, 'purchase_return_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4533, 1, 18, 'purchase_return_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4534, 1, 18, 'purchase_return_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4535, 1, 18, 'purchase_return_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4536, 1, 18, 'purchase_return_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4537, 1, 18, 'purchase_return_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4538, 1, 18, 'purchase_return_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4539, 1, 18, 'purchase_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4540, 1, 18, 'purchase_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4541, 1, 18, 'purchase_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4542, 1, 18, 'payment_types_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4543, 1, 18, 'payment_types_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4544, 1, 18, 'payment_types_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4545, 1, 18, 'payment_types_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4546, 1, 18, 'import_suppliers');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4547, 1, 18, 'stock_transfer_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4548, 1, 18, 'stock_transfer_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4549, 1, 18, 'stock_transfer_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4550, 1, 18, 'stock_transfer_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4551, 1, 18, 'warehouse_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4552, 1, 18, 'warehouse_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4553, 1, 18, 'warehouse_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4554, 1, 18, 'warehouse_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4555, 1, 18, 'services_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4556, 1, 18, 'services_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4557, 1, 18, 'services_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4558, 1, 18, 'services_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4559, 1, 18, 'import_services');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4560, 1, 18, 'stock_adjustment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4561, 1, 18, 'stock_adjustment_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4562, 1, 18, 'stock_adjustment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4563, 1, 18, 'stock_adjustment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4564, 1, 18, 'variant_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4565, 1, 18, 'variant_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4566, 1, 18, 'variant_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4567, 1, 18, 'variant_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4568, 1, 18, 'accounts_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4569, 1, 18, 'accounts_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4570, 1, 18, 'accounts_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4571, 1, 18, 'accounts_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4572, 1, 18, 'money_transfer_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4573, 1, 18, 'money_transfer_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4574, 1, 18, 'money_transfer_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4575, 1, 18, 'money_transfer_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4576, 1, 18, 'money_deposit_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4577, 1, 18, 'money_deposit_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4578, 1, 18, 'money_deposit_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4579, 1, 18, 'money_deposit_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (4580, 1, 18, 'purchase_tax_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5818, 1, 2, 'users_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5819, 1, 2, 'users_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5820, 1, 2, 'users_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5821, 1, 2, 'users_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5822, 1, 2, 'tax_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5823, 1, 2, 'tax_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5824, 1, 2, 'tax_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5825, 1, 2, 'tax_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5826, 1, 2, 'store_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5827, 1, 2, 'units_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5828, 1, 2, 'units_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5829, 1, 2, 'units_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5830, 1, 2, 'units_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5831, 1, 2, 'roles_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5832, 1, 2, 'roles_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5833, 1, 2, 'roles_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5834, 1, 2, 'roles_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5835, 1, 2, 'expense_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5836, 1, 2, 'expense_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5837, 1, 2, 'expense_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5838, 1, 2, 'expense_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5839, 1, 2, 'items_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5840, 1, 2, 'items_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5841, 1, 2, 'items_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5842, 1, 2, 'items_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5843, 1, 2, 'import_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5844, 1, 2, 'brand_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5845, 1, 2, 'brand_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5846, 1, 2, 'brand_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5847, 1, 2, 'brand_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5848, 1, 2, 'suppliers_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5849, 1, 2, 'suppliers_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5850, 1, 2, 'suppliers_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5851, 1, 2, 'suppliers_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5852, 1, 2, 'customers_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5853, 1, 2, 'customers_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5854, 1, 2, 'customers_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5855, 1, 2, 'customers_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5856, 1, 2, 'purchase_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5857, 1, 2, 'purchase_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5858, 1, 2, 'purchase_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5859, 1, 2, 'purchase_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5860, 1, 2, 'sales_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5861, 1, 2, 'sales_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5862, 1, 2, 'sales_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5863, 1, 2, 'sales_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5864, 1, 2, 'sales_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5865, 1, 2, 'sales_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5866, 1, 2, 'sales_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5867, 1, 2, 'sales_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5868, 1, 2, 'purchase_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5869, 1, 2, 'expense_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5870, 1, 2, 'profit_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5871, 1, 2, 'stock_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5872, 1, 2, 'item_sales_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5873, 1, 2, 'purchase_payments_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5874, 1, 2, 'sales_payments_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5875, 1, 2, 'items_category_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5876, 1, 2, 'items_category_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5877, 1, 2, 'items_category_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5878, 1, 2, 'items_category_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5879, 1, 2, 'print_labels');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5880, 1, 2, 'expense_category_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5881, 1, 2, 'expense_category_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5882, 1, 2, 'expense_category_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5883, 1, 2, 'expense_category_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5884, 1, 2, 'dashboard_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5885, 1, 2, 'dashboard_info_box_1');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5886, 1, 2, 'dashboard_info_box_2');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5887, 1, 2, 'dashboard_pur_sal_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5888, 1, 2, 'dashboard_recent_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5889, 1, 2, 'dashboard_stock_alert');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5890, 1, 2, 'dashboard_trending_items_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5891, 1, 2, 'send_sms');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5892, 1, 2, 'sms_template_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5893, 1, 2, 'sms_template_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5894, 1, 2, 'sms_api_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5895, 1, 2, 'sms_api_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5896, 1, 2, 'purchase_return_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5897, 1, 2, 'purchase_return_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5898, 1, 2, 'purchase_return_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5899, 1, 2, 'purchase_return_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5900, 1, 2, 'purchase_return_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5901, 1, 2, 'sales_return_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5902, 1, 2, 'sales_return_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5903, 1, 2, 'sales_return_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5904, 1, 2, 'sales_return_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5905, 1, 2, 'sales_return_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5906, 1, 2, 'sales_return_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5907, 1, 2, 'sales_return_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5908, 1, 2, 'sales_return_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5909, 1, 2, 'purchase_return_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5910, 1, 2, 'purchase_return_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5911, 1, 2, 'purchase_return_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5912, 1, 2, 'purchase_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5913, 1, 2, 'purchase_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5914, 1, 2, 'purchase_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5915, 1, 2, 'payment_types_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5916, 1, 2, 'payment_types_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5917, 1, 2, 'payment_types_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5918, 1, 2, 'payment_types_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5919, 1, 2, 'import_customers');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5920, 1, 2, 'import_suppliers');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5921, 1, 2, 'stock_transfer_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5922, 1, 2, 'stock_transfer_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5923, 1, 2, 'stock_transfer_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5924, 1, 2, 'stock_transfer_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5925, 1, 2, 'warehouse_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5926, 1, 2, 'warehouse_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5927, 1, 2, 'warehouse_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5928, 1, 2, 'warehouse_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5929, 1, 2, 'supplier_items_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5930, 1, 2, 'seller_points_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5931, 1, 2, 'services_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5932, 1, 2, 'services_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5933, 1, 2, 'services_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5934, 1, 2, 'services_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5935, 1, 2, 'quotation_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5936, 1, 2, 'quotation_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5937, 1, 2, 'quotation_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5938, 1, 2, 'quotation_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5939, 1, 2, 'import_services');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5940, 1, 2, 'stock_adjustment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5941, 1, 2, 'stock_adjustment_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5942, 1, 2, 'stock_adjustment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5943, 1, 2, 'stock_adjustment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5944, 1, 2, 'variant_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5945, 1, 2, 'variant_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5946, 1, 2, 'variant_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5947, 1, 2, 'variant_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5948, 1, 2, 'accounts_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5949, 1, 2, 'accounts_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5950, 1, 2, 'accounts_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5951, 1, 2, 'accounts_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5952, 1, 2, 'money_transfer_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5953, 1, 2, 'money_transfer_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5954, 1, 2, 'money_transfer_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5955, 1, 2, 'money_transfer_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5956, 1, 2, 'money_deposit_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5957, 1, 2, 'money_deposit_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5958, 1, 2, 'money_deposit_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5959, 1, 2, 'money_deposit_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5960, 1, 2, 'sales_tax_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5961, 1, 2, 'purchase_tax_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5962, 1, 2, 'cash_transactions');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5963, 1, 2, 'show_all_users_sales_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5964, 1, 2, 'show_all_users_sales_return_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5965, 1, 2, 'show_all_users_purchase_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5966, 1, 2, 'show_all_users_purchase_return_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5967, 1, 2, 'show_all_users_expenses');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5968, 1, 2, 'show_all_users_quotations');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5969, 1, 2, 'subscription');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5970, 1, 2, 'smtp_settings');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5971, 1, 2, 'send_email');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5972, 1, 2, 'sms_settings');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5973, 1, 2, 'email_template_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5974, 1, 2, 'email_template_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5975, 1, 2, 'cust_adv_payments_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5976, 1, 2, 'cust_adv_payments_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5977, 1, 2, 'cust_adv_payments_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5978, 1, 2, 'cust_adv_payments_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (5999, 2, 28, 'cust_adv_payments_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6000, 2, 28, 'cust_adv_payments_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6001, 2, 28, 'cust_adv_payments_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6002, 2, 28, 'cust_adv_payments_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6011, 2, 29, 'users_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6012, 2, 29, 'users_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6013, 2, 29, 'users_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6014, 2, 29, 'users_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6015, 2, 29, 'tax_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6016, 2, 29, 'tax_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6017, 2, 29, 'tax_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6018, 2, 29, 'tax_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6019, 2, 29, 'store_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6020, 2, 29, 'units_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6021, 2, 29, 'units_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6022, 2, 29, 'units_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6023, 2, 29, 'units_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6024, 2, 29, 'roles_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6025, 2, 29, 'roles_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6026, 2, 29, 'roles_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6027, 2, 29, 'roles_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6028, 2, 29, 'expense_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6029, 2, 29, 'expense_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6030, 2, 29, 'expense_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6031, 2, 29, 'expense_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6032, 2, 29, 'items_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6033, 2, 29, 'items_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6034, 2, 29, 'items_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6035, 2, 29, 'items_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6036, 2, 29, 'import_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6037, 2, 29, 'brand_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6038, 2, 29, 'brand_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6039, 2, 29, 'brand_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6040, 2, 29, 'brand_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6041, 2, 29, 'suppliers_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6042, 2, 29, 'suppliers_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6043, 2, 29, 'suppliers_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6044, 2, 29, 'suppliers_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6045, 2, 29, 'customers_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6046, 2, 29, 'customers_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6047, 2, 29, 'customers_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6048, 2, 29, 'customers_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6049, 2, 29, 'purchase_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6050, 2, 29, 'purchase_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6051, 2, 29, 'purchase_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6052, 2, 29, 'purchase_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6053, 2, 29, 'sales_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6054, 2, 29, 'sales_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6055, 2, 29, 'sales_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6056, 2, 29, 'sales_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6057, 2, 29, 'sales_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6058, 2, 29, 'sales_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6059, 2, 29, 'sales_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6060, 2, 29, 'sales_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6061, 2, 29, 'purchase_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6062, 2, 29, 'expense_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6063, 2, 29, 'profit_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6064, 2, 29, 'stock_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6065, 2, 29, 'item_sales_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6066, 2, 29, 'purchase_payments_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6067, 2, 29, 'sales_payments_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6068, 2, 29, 'items_category_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6069, 2, 29, 'items_category_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6070, 2, 29, 'items_category_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6071, 2, 29, 'items_category_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6072, 2, 29, 'print_labels');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6073, 2, 29, 'expense_category_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6074, 2, 29, 'expense_category_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6075, 2, 29, 'expense_category_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6076, 2, 29, 'expense_category_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6077, 2, 29, 'dashboard_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6078, 2, 29, 'dashboard_info_box_1');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6079, 2, 29, 'dashboard_info_box_2');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6080, 2, 29, 'dashboard_pur_sal_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6081, 2, 29, 'dashboard_recent_items');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6082, 2, 29, 'dashboard_stock_alert');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6083, 2, 29, 'dashboard_trending_items_chart');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6084, 2, 29, 'send_sms');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6085, 2, 29, 'sms_template_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6086, 2, 29, 'sms_template_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6087, 2, 29, 'sms_api_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6088, 2, 29, 'sms_api_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6089, 2, 29, 'purchase_return_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6090, 2, 29, 'purchase_return_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6091, 2, 29, 'purchase_return_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6092, 2, 29, 'purchase_return_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6093, 2, 29, 'purchase_return_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6094, 2, 29, 'sales_return_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6095, 2, 29, 'sales_return_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6096, 2, 29, 'sales_return_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6097, 2, 29, 'sales_return_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6098, 2, 29, 'sales_return_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6099, 2, 29, 'sales_return_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6100, 2, 29, 'sales_return_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6101, 2, 29, 'sales_return_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6102, 2, 29, 'purchase_return_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6103, 2, 29, 'purchase_return_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6104, 2, 29, 'purchase_return_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6105, 2, 29, 'purchase_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6106, 2, 29, 'purchase_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6107, 2, 29, 'purchase_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6108, 2, 29, 'payment_types_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6109, 2, 29, 'payment_types_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6110, 2, 29, 'payment_types_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6111, 2, 29, 'payment_types_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6112, 2, 29, 'import_customers');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6113, 2, 29, 'import_suppliers');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6114, 2, 29, 'stock_transfer_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6115, 2, 29, 'stock_transfer_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6116, 2, 29, 'stock_transfer_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6117, 2, 29, 'stock_transfer_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6118, 2, 29, 'warehouse_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6119, 2, 29, 'warehouse_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6120, 2, 29, 'warehouse_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6121, 2, 29, 'warehouse_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6122, 2, 29, 'supplier_items_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6123, 2, 29, 'seller_points_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6124, 2, 29, 'services_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6125, 2, 29, 'services_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6126, 2, 29, 'services_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6127, 2, 29, 'services_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6128, 2, 29, 'quotation_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6129, 2, 29, 'quotation_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6130, 2, 29, 'quotation_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6131, 2, 29, 'quotation_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6132, 2, 29, 'import_services');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6133, 2, 29, 'stock_adjustment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6134, 2, 29, 'stock_adjustment_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6135, 2, 29, 'stock_adjustment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6136, 2, 29, 'stock_adjustment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6137, 2, 29, 'variant_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6138, 2, 29, 'variant_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6139, 2, 29, 'variant_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6140, 2, 29, 'variant_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6141, 2, 29, 'accounts_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6142, 2, 29, 'accounts_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6143, 2, 29, 'accounts_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6144, 2, 29, 'accounts_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6145, 2, 29, 'money_transfer_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6146, 2, 29, 'money_transfer_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6147, 2, 29, 'money_transfer_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6148, 2, 29, 'money_transfer_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6149, 2, 29, 'money_deposit_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6150, 2, 29, 'money_deposit_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6151, 2, 29, 'money_deposit_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6152, 2, 29, 'money_deposit_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6153, 2, 29, 'sales_tax_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6154, 2, 29, 'purchase_tax_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6155, 2, 29, 'cash_transactions');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6156, 2, 29, 'show_all_users_sales_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6157, 2, 29, 'show_all_users_sales_return_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6158, 2, 29, 'show_all_users_purchase_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6159, 2, 29, 'show_all_users_purchase_return_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6160, 2, 29, 'show_all_users_expenses');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6161, 2, 29, 'show_all_users_quotations');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6162, 2, 29, 'smtp_settings');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6163, 2, 29, 'send_email');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6164, 2, 29, 'sms_settings');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6165, 2, 29, 'email_template_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6166, 2, 29, 'email_template_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6167, 2, 29, 'cust_adv_payments_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6168, 2, 29, 'cust_adv_payments_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6169, 2, 29, 'cust_adv_payments_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6170, 2, 29, 'cust_adv_payments_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6179, 1, 2, 'gstr_1_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6180, 1, 2, 'gstr_2_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6181, 1, 2, 'delivery_sheet_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6182, 1, 2, 'load_sheet_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6183, 1, 2, 'show_purchase_price');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6184, 1, 2, 'customer_orders_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6185, 1, 2, 'discountCouponAdd');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6186, 1, 2, 'discountCouponEdit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6187, 1, 2, 'discountCouponDelete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6188, 1, 2, 'discountCouponView');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6189, 2, 2, 'sales_gst_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6190, 2, 2, 'purchase_gst_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6191, 2, 2, 'subscription');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6192, 1, 2, 'customerCouponAdd');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6193, 1, 2, 'customerCouponEdit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6194, 1, 2, 'customerCouponDelete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6195, 1, 2, 'customerCouponView');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6196, 1, 2, 'return_items_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6197, 1, 2, 'help_link');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6198, 2, 31, 'sales_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6199, 2, 31, 'sales_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6200, 2, 31, 'sales_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6201, 2, 31, 'sales_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6202, 2, 31, 'sales_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6203, 2, 31, 'sales_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6204, 2, 31, 'sales_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6205, 2, 31, 'sales_return_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6206, 2, 31, 'sales_return_edit');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6207, 2, 31, 'sales_return_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6208, 2, 31, 'sales_return_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6209, 2, 31, 'sales_return_payment_view');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6210, 2, 31, 'sales_return_payment_add');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6211, 2, 31, 'sales_return_payment_delete');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6212, 2, 31, 'show_all_users_sales_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6213, 2, 31, 'show_all_users_sales_return_invoices');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6214, 2, 31, 'show_purchase_price');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6215, 2, 2, 'recent_sales_invoice_list');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6216, 1, 2, 'stock_transfer_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6217, 1, 2, 'pos');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6218, 1, 2, 'sales_summary_report');
INSERT INTO `db_permissions` (`id`, `store_id`, `role_id`, `permissions`) VALUES (6219, 1, 2, 'sales_return_payments');


#
# TABLE STRUCTURE FOR: db_purchase
#

DROP TABLE IF EXISTS `db_purchase`;

CREATE TABLE `db_purchase` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `warehouse_id` int(11) DEFAULT NULL,
  `count_id` int(11) DEFAULT NULL COMMENT 'Use to create Purchase Code',
  `purchase_code` varchar(50) DEFAULT NULL,
  `reference_no` varchar(50) DEFAULT NULL,
  `purchase_date` date DEFAULT NULL,
  `purchase_status` varchar(50) DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `other_charges_input` double(20,4) DEFAULT NULL,
  `other_charges_tax_id` int(11) DEFAULT NULL,
  `other_charges_amt` double(20,4) DEFAULT NULL,
  `discount_to_all_input` double(20,4) DEFAULT NULL,
  `discount_to_all_type` varchar(50) DEFAULT NULL,
  `tot_discount_to_all_amt` double(20,4) DEFAULT NULL,
  `subtotal` double(20,4) DEFAULT NULL COMMENT 'Purchased qty',
  `round_off` double(20,4) DEFAULT NULL COMMENT 'Pending Qty',
  `grand_total` double(20,4) DEFAULT NULL,
  `purchase_note` text DEFAULT NULL,
  `payment_status` varchar(50) DEFAULT NULL,
  `paid_amount` double(20,4) DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) DEFAULT NULL,
  `created_by` varchar(50) DEFAULT NULL,
  `system_ip` varchar(100) DEFAULT NULL,
  `system_name` varchar(100) DEFAULT NULL,
  `company_id` int(11) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `return_bit` int(11) DEFAULT NULL COMMENT 'Purchase return raised',
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `supplier_id` (`supplier_id`),
  CONSTRAINT `db_purchase_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_purchase_ibfk_2` FOREIGN KEY (`supplier_id`) REFERENCES `db_suppliers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_purchaseitems
#

DROP TABLE IF EXISTS `db_purchaseitems`;

CREATE TABLE `db_purchaseitems` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `purchase_id` int(11) DEFAULT NULL,
  `purchase_status` varchar(50) DEFAULT NULL,
  `item_id` int(11) DEFAULT NULL,
  `purchase_qty` double(20,2) DEFAULT NULL,
  `price_per_unit` double(20,4) DEFAULT NULL,
  `tax_type` varchar(50) DEFAULT NULL,
  `tax_id` int(11) DEFAULT NULL,
  `tax_amt` double(20,4) DEFAULT NULL,
  `discount_type` varchar(50) DEFAULT NULL,
  `discount_input` double(20,4) DEFAULT NULL,
  `discount_amt` double(20,4) DEFAULT NULL,
  `unit_total_cost` double(20,4) DEFAULT NULL,
  `total_cost` double(20,4) DEFAULT NULL,
  `profit_margin_per` double(20,4) DEFAULT NULL,
  `unit_sales_price` double(20,4) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `description` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `purchase_id` (`purchase_id`),
  CONSTRAINT `db_purchaseitems_ibfk_1` FOREIGN KEY (`purchase_id`) REFERENCES `db_purchase` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=203 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_purchaseitemsreturn
#

DROP TABLE IF EXISTS `db_purchaseitemsreturn`;

CREATE TABLE `db_purchaseitemsreturn` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `purchase_id` int(11) DEFAULT NULL,
  `return_id` int(11) DEFAULT NULL,
  `return_status` varchar(50) DEFAULT NULL,
  `item_id` int(11) DEFAULT NULL,
  `return_qty` double(20,2) DEFAULT NULL,
  `price_per_unit` double(20,4) DEFAULT NULL,
  `tax_id` int(11) DEFAULT NULL,
  `tax_amt` double(20,4) DEFAULT NULL,
  `tax_type` varchar(50) DEFAULT NULL,
  `discount_input` double(20,4) DEFAULT NULL,
  `discount_amt` double(20,4) DEFAULT NULL,
  `discount_type` varchar(50) DEFAULT NULL,
  `unit_total_cost` double(20,4) DEFAULT NULL,
  `total_cost` double(20,4) DEFAULT NULL,
  `profit_margin_per` double(20,4) DEFAULT NULL,
  `unit_sales_price` double(20,4) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `description` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `return_id` (`return_id`),
  KEY `purchase_id` (`purchase_id`),
  CONSTRAINT `db_purchaseitemsreturn_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_purchaseitemsreturn_ibfk_2` FOREIGN KEY (`return_id`) REFERENCES `db_purchasereturn` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=61 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_purchasepayments
#

DROP TABLE IF EXISTS `db_purchasepayments`;

CREATE TABLE `db_purchasepayments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `count_id` int(11) DEFAULT NULL,
  `payment_code` varchar(50) DEFAULT NULL,
  `store_id` int(11) DEFAULT NULL,
  `purchase_id` int(11) DEFAULT NULL,
  `payment_date` date DEFAULT NULL,
  `payment_type` varchar(50) DEFAULT NULL,
  `payment` double(20,4) DEFAULT NULL,
  `payment_note` text DEFAULT NULL,
  `system_ip` varchar(50) DEFAULT NULL,
  `system_name` varchar(50) DEFAULT NULL,
  `created_time` time DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_by` varchar(50) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `account_id` int(11) DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `short_code` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `purchase_id` (`purchase_id`),
  KEY `supplier_id` (`supplier_id`),
  CONSTRAINT `db_purchasepayments_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_purchasepayments_ibfk_2` FOREIGN KEY (`purchase_id`) REFERENCES `db_purchase` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_purchasepayments_ibfk_3` FOREIGN KEY (`supplier_id`) REFERENCES `db_suppliers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=110 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_purchasepaymentsreturn
#

DROP TABLE IF EXISTS `db_purchasepaymentsreturn`;

CREATE TABLE `db_purchasepaymentsreturn` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `count_id` int(11) DEFAULT NULL,
  `payment_code` varchar(50) DEFAULT NULL,
  `store_id` int(11) DEFAULT NULL,
  `purchase_id` int(11) DEFAULT NULL,
  `return_id` int(11) DEFAULT NULL,
  `payment_date` date DEFAULT NULL,
  `payment_type` varchar(50) DEFAULT NULL,
  `payment` double(20,4) DEFAULT NULL,
  `payment_note` text DEFAULT NULL,
  `system_ip` varchar(50) DEFAULT NULL,
  `system_name` varchar(50) DEFAULT NULL,
  `created_time` time DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_by` varchar(50) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `account_id` int(11) DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `short_code` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `return_id` (`return_id`),
  KEY `supplier_id` (`supplier_id`),
  CONSTRAINT `db_purchasepaymentsreturn_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_purchasepaymentsreturn_ibfk_2` FOREIGN KEY (`return_id`) REFERENCES `db_purchasereturn` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_purchasepaymentsreturn_ibfk_3` FOREIGN KEY (`supplier_id`) REFERENCES `db_suppliers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=122 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_purchasereturn
#

DROP TABLE IF EXISTS `db_purchasereturn`;

CREATE TABLE `db_purchasereturn` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `count_id` int(11) DEFAULT NULL COMMENT 'Use to create Purchase Return Code',
  `warehouse_id` int(11) DEFAULT NULL,
  `purchase_id` int(11) DEFAULT NULL,
  `return_code` varchar(50) DEFAULT NULL,
  `reference_no` varchar(50) DEFAULT NULL,
  `return_date` date DEFAULT NULL,
  `return_status` varchar(50) DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `other_charges_input` double(20,4) DEFAULT NULL,
  `other_charges_tax_id` int(11) DEFAULT NULL,
  `other_charges_amt` double(20,4) DEFAULT NULL,
  `discount_to_all_input` double(20,4) DEFAULT NULL,
  `discount_to_all_type` varchar(50) DEFAULT NULL,
  `tot_discount_to_all_amt` double(20,4) DEFAULT NULL,
  `subtotal` double(20,4) DEFAULT NULL COMMENT 'Purchased qty',
  `round_off` double(20,4) DEFAULT NULL COMMENT 'Pending Qty',
  `grand_total` double(20,4) DEFAULT NULL,
  `return_note` text DEFAULT NULL,
  `payment_status` varchar(50) DEFAULT NULL,
  `paid_amount` double(20,4) DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) DEFAULT NULL,
  `created_by` varchar(50) DEFAULT NULL,
  `system_ip` varchar(100) DEFAULT NULL,
  `system_name` varchar(100) DEFAULT NULL,
  `company_id` int(11) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `purchase_id` (`purchase_id`),
  CONSTRAINT `db_purchasereturn_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_purchasereturn_ibfk_2` FOREIGN KEY (`purchase_id`) REFERENCES `db_purchase` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_quotation
#

DROP TABLE IF EXISTS `db_quotation`;

CREATE TABLE `db_quotation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `warehouse_id` int(11) DEFAULT NULL,
  `count_id` int(11) DEFAULT NULL COMMENT 'Use to create quotation Code',
  `quotation_code` varchar(50) DEFAULT NULL,
  `reference_no` varchar(50) DEFAULT NULL,
  `quotation_date` date DEFAULT NULL,
  `expire_date` date DEFAULT NULL,
  `quotation_status` varchar(50) DEFAULT NULL,
  `customer_id` int(11) DEFAULT NULL,
  `other_charges_input` double(20,4) DEFAULT NULL,
  `other_charges_tax_id` int(11) DEFAULT NULL,
  `other_charges_amt` double(20,4) DEFAULT NULL,
  `discount_to_all_input` double(20,4) DEFAULT NULL,
  `discount_to_all_type` varchar(50) DEFAULT NULL,
  `tot_discount_to_all_amt` double(20,4) DEFAULT NULL,
  `subtotal` double(20,4) DEFAULT NULL,
  `round_off` double(20,4) DEFAULT NULL,
  `grand_total` double(20,4) DEFAULT NULL,
  `quotation_note` text DEFAULT NULL,
  `payment_status` varchar(50) DEFAULT NULL,
  `paid_amount` double(20,4) DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) DEFAULT NULL,
  `created_by` varchar(50) DEFAULT NULL,
  `system_ip` varchar(100) DEFAULT NULL,
  `system_name` varchar(100) DEFAULT NULL,
  `company_id` int(11) DEFAULT NULL,
  `pos` int(11) DEFAULT NULL COMMENT '1=yes 0=no',
  `status` int(11) DEFAULT NULL,
  `return_bit` int(11) DEFAULT NULL COMMENT 'quotation return raised',
  `customer_previous_due` double(20,4) DEFAULT NULL,
  `customer_total_due` double(20,4) DEFAULT NULL,
  `sales_status` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `customer_id` (`customer_id`),
  KEY `warehouse_id` (`warehouse_id`),
  CONSTRAINT `db_quotation_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_quotation_ibfk_2` FOREIGN KEY (`customer_id`) REFERENCES `db_customers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_quotation_ibfk_3` FOREIGN KEY (`warehouse_id`) REFERENCES `db_warehouse` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_quotationitems
#

DROP TABLE IF EXISTS `db_quotationitems`;

CREATE TABLE `db_quotationitems` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `quotation_id` int(11) DEFAULT NULL,
  `quotation_status` varchar(50) DEFAULT NULL,
  `item_id` int(11) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `quotation_qty` double(20,2) DEFAULT NULL,
  `price_per_unit` double(20,4) DEFAULT NULL,
  `tax_type` varchar(50) DEFAULT NULL,
  `tax_id` int(11) DEFAULT NULL,
  `tax_amt` double(20,4) DEFAULT NULL,
  `discount_type` varchar(50) DEFAULT NULL,
  `discount_input` double(20,4) DEFAULT NULL,
  `discount_amt` double(20,4) DEFAULT NULL,
  `unit_total_cost` double(20,4) DEFAULT NULL,
  `total_cost` double(20,4) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `seller_points` double(20,4) DEFAULT 0.0000,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `quotation_id` (`quotation_id`),
  CONSTRAINT `db_quotationitems_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_quotationitems_ibfk_2` FOREIGN KEY (`quotation_id`) REFERENCES `db_quotation` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=288 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_roles
#

DROP TABLE IF EXISTS `db_roles`;

CREATE TABLE `db_roles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `role_name` varchar(50) DEFAULT NULL,
  `description` mediumtext DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_roles_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_roles` (`id`, `store_id`, `role_name`, `description`, `status`) VALUES (1, 1, 'Admin', 'All Rights Permitted.', 1);
INSERT INTO `db_roles` (`id`, `store_id`, `role_name`, `description`, `status`) VALUES (2, 1, 'Store Admin', 'Note: Apply this role for New Store Admin. ', 1);
INSERT INTO `db_roles` (`id`, `store_id`, `role_name`, `description`, `status`) VALUES (31, 2, 'Cashier', '', 1);


#
# TABLE STRUCTURE FOR: db_sales
#

DROP TABLE IF EXISTS `db_sales`;

CREATE TABLE `db_sales` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `warehouse_id` int(11) DEFAULT NULL,
  `init_code` varchar(100) DEFAULT NULL,
  `count_id` decimal(20,0) DEFAULT NULL COMMENT 'Use to create Sales Code',
  `sales_code` varchar(50) DEFAULT NULL,
  `reference_no` varchar(50) DEFAULT NULL,
  `sales_date` date DEFAULT NULL,
  `due_date` date DEFAULT NULL,
  `sales_status` varchar(50) DEFAULT NULL,
  `customer_id` int(11) DEFAULT NULL,
  `other_charges_input` double(20,2) DEFAULT NULL,
  `other_charges_tax_id` int(11) DEFAULT NULL,
  `other_charges_amt` double(20,2) DEFAULT NULL,
  `discount_to_all_input` double(20,2) DEFAULT NULL,
  `discount_to_all_type` varchar(50) DEFAULT NULL,
  `tot_discount_to_all_amt` double(20,2) DEFAULT NULL,
  `subtotal` double(20,2) DEFAULT NULL,
  `round_off` double(20,2) DEFAULT NULL,
  `grand_total` double(20,4) DEFAULT NULL,
  `sales_note` text DEFAULT NULL,
  `payment_status` varchar(50) DEFAULT NULL,
  `paid_amount` double(20,4) DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) DEFAULT NULL,
  `created_by` varchar(50) DEFAULT NULL,
  `system_ip` varchar(100) DEFAULT NULL,
  `system_name` varchar(100) DEFAULT NULL,
  `company_id` int(11) DEFAULT NULL,
  `pos` int(11) DEFAULT NULL COMMENT '1=yes 0=no',
  `status` int(11) DEFAULT NULL,
  `return_bit` int(11) DEFAULT NULL COMMENT 'sales return raised',
  `customer_previous_due` double(20,2) DEFAULT NULL,
  `customer_total_due` double(20,2) DEFAULT NULL,
  `quotation_id` int(11) DEFAULT NULL,
  `coupon_id` int(11) DEFAULT NULL,
  `coupon_amt` double(20,2) DEFAULT 0.00,
  `invoice_terms` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `customer_id` (`customer_id`),
  KEY `warehouse_id` (`warehouse_id`),
  KEY `coupon_id` (`coupon_id`),
  CONSTRAINT `db_sales_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_sales_ibfk_2` FOREIGN KEY (`customer_id`) REFERENCES `db_customers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_sales_ibfk_3` FOREIGN KEY (`warehouse_id`) REFERENCES `db_warehouse` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_sales_ibfk_4` FOREIGN KEY (`coupon_id`) REFERENCES `db_customer_coupons` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=60 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_salesitems
#

DROP TABLE IF EXISTS `db_salesitems`;

CREATE TABLE `db_salesitems` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `sales_id` int(11) DEFAULT NULL,
  `sales_status` varchar(50) DEFAULT NULL,
  `item_id` int(11) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `sales_qty` double(20,2) DEFAULT NULL,
  `price_per_unit` double(20,4) DEFAULT NULL,
  `tax_type` varchar(50) DEFAULT NULL,
  `tax_id` int(11) DEFAULT NULL,
  `tax_amt` double(20,4) DEFAULT NULL,
  `discount_type` varchar(50) DEFAULT NULL,
  `discount_input` double(20,4) DEFAULT NULL,
  `discount_amt` double(20,4) DEFAULT NULL,
  `unit_total_cost` double(20,4) DEFAULT NULL,
  `total_cost` double(20,4) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `seller_points` double(20,2) DEFAULT 0.00,
  `purchase_price` double(20,3) DEFAULT 0.000,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `sales_id` (`sales_id`),
  CONSTRAINT `db_salesitems_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_salesitems_ibfk_2` FOREIGN KEY (`sales_id`) REFERENCES `db_sales` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=621 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_salesitemsreturn
#

DROP TABLE IF EXISTS `db_salesitemsreturn`;

CREATE TABLE `db_salesitemsreturn` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `sales_id` int(11) DEFAULT NULL,
  `return_id` int(11) DEFAULT NULL,
  `return_status` varchar(50) DEFAULT NULL,
  `item_id` int(11) DEFAULT NULL,
  `return_qty` double(20,2) DEFAULT NULL,
  `price_per_unit` double(20,4) DEFAULT NULL,
  `tax_type` varchar(50) DEFAULT NULL,
  `tax_id` int(11) DEFAULT NULL,
  `tax_amt` double(20,4) DEFAULT NULL,
  `discount_input` double(20,4) DEFAULT NULL,
  `discount_amt` double(20,4) DEFAULT NULL,
  `discount_type` varchar(50) DEFAULT NULL,
  `unit_total_cost` double(20,4) DEFAULT NULL,
  `total_cost` double(20,4) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `purchase_price` double(20,3) DEFAULT 0.000,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `return_id` (`return_id`),
  CONSTRAINT `db_salesitemsreturn_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_salesitemsreturn_ibfk_2` FOREIGN KEY (`return_id`) REFERENCES `db_salesreturn` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=86 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_salespayments
#

DROP TABLE IF EXISTS `db_salespayments`;

CREATE TABLE `db_salespayments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `count_id` int(11) DEFAULT NULL,
  `payment_code` varchar(50) DEFAULT NULL,
  `store_id` int(11) DEFAULT NULL,
  `sales_id` int(11) DEFAULT NULL,
  `payment_date` date DEFAULT NULL,
  `payment_type` varchar(50) DEFAULT NULL,
  `payment` double(20,4) DEFAULT NULL,
  `payment_note` text DEFAULT NULL,
  `change_return` double(20,4) DEFAULT NULL COMMENT 'Refunding the greater amount',
  `system_ip` varchar(50) DEFAULT NULL,
  `system_name` varchar(50) DEFAULT NULL,
  `created_time` varchar(50) DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_by` varchar(50) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `account_id` int(11) DEFAULT NULL,
  `customer_id` int(11) DEFAULT NULL,
  `short_code` varchar(50) DEFAULT NULL,
  `advance_adjusted` double(20,4) DEFAULT NULL,
  `cheque_number` varchar(100) DEFAULT NULL,
  `cheque_period` int(11) DEFAULT NULL,
  `cheque_status` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `sales_id` (`sales_id`),
  KEY `customer_id` (`customer_id`),
  CONSTRAINT `db_salespayments_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_salespayments_ibfk_2` FOREIGN KEY (`sales_id`) REFERENCES `db_sales` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_salespayments_ibfk_3` FOREIGN KEY (`customer_id`) REFERENCES `db_customers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=350 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_salespaymentsreturn
#

DROP TABLE IF EXISTS `db_salespaymentsreturn`;

CREATE TABLE `db_salespaymentsreturn` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `count_id` int(11) DEFAULT NULL,
  `payment_code` varchar(50) DEFAULT NULL,
  `store_id` int(11) DEFAULT NULL,
  `sales_id` int(11) DEFAULT NULL,
  `return_id` int(11) DEFAULT NULL,
  `payment_date` date DEFAULT NULL,
  `payment_type` varchar(50) DEFAULT NULL,
  `payment` double(20,4) DEFAULT NULL,
  `payment_note` text DEFAULT NULL,
  `change_return` double(20,4) DEFAULT NULL COMMENT 'Refunding the greater amount',
  `system_ip` varchar(50) DEFAULT NULL,
  `system_name` varchar(50) DEFAULT NULL,
  `created_time` time DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_by` varchar(50) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `account_id` int(11) DEFAULT NULL,
  `customer_id` int(11) DEFAULT NULL,
  `short_code` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `return_id` (`return_id`),
  KEY `db_salespaymentsreturn_ibfk_3` (`customer_id`),
  CONSTRAINT `db_salespaymentsreturn_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_salespaymentsreturn_ibfk_2` FOREIGN KEY (`return_id`) REFERENCES `db_salesreturn` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_salespaymentsreturn_ibfk_3` FOREIGN KEY (`customer_id`) REFERENCES `db_customers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=46 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_salesreturn
#

DROP TABLE IF EXISTS `db_salesreturn`;

CREATE TABLE `db_salesreturn` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `count_id` int(11) DEFAULT NULL COMMENT 'Use to create Sales Return Code',
  `sales_id` int(11) DEFAULT NULL,
  `warehouse_id` int(11) DEFAULT NULL,
  `return_code` varchar(50) DEFAULT NULL,
  `reference_no` varchar(50) DEFAULT NULL,
  `return_date` date DEFAULT NULL,
  `return_status` varchar(50) DEFAULT NULL,
  `customer_id` int(11) DEFAULT NULL,
  `other_charges_input` double(20,4) DEFAULT NULL,
  `other_charges_tax_id` int(11) DEFAULT NULL,
  `other_charges_amt` double(20,4) DEFAULT NULL,
  `discount_to_all_input` double(20,4) DEFAULT NULL,
  `discount_to_all_type` varchar(50) DEFAULT NULL,
  `tot_discount_to_all_amt` double(20,4) DEFAULT NULL,
  `subtotal` double(20,4) DEFAULT NULL,
  `round_off` double(20,4) DEFAULT NULL,
  `grand_total` double(20,4) DEFAULT NULL,
  `return_note` text DEFAULT NULL,
  `payment_status` varchar(50) DEFAULT NULL,
  `paid_amount` double(20,4) DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) DEFAULT NULL,
  `created_by` varchar(50) DEFAULT NULL,
  `system_ip` varchar(100) DEFAULT NULL,
  `system_name` varchar(100) DEFAULT NULL,
  `company_id` int(11) DEFAULT NULL,
  `pos` int(11) DEFAULT NULL COMMENT '1=yes 0=no',
  `status` int(11) DEFAULT NULL,
  `return_bit` int(11) DEFAULT NULL COMMENT 'Return raised or not 1 or null',
  `coupon_id` int(11) DEFAULT NULL,
  `coupon_amt` double(20,2) DEFAULT 0.00,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `sales_id` (`sales_id`),
  KEY `coupon_id` (`coupon_id`),
  CONSTRAINT `db_salesreturn_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_salesreturn_ibfk_2` FOREIGN KEY (`sales_id`) REFERENCES `db_sales` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_salesreturn_ibfk_3` FOREIGN KEY (`coupon_id`) REFERENCES `db_customer_coupons` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_shippingaddress
#

DROP TABLE IF EXISTS `db_shippingaddress`;

CREATE TABLE `db_shippingaddress` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `country_id` int(11) DEFAULT NULL,
  `state_id` int(11) DEFAULT NULL,
  `city` varchar(100) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `postcode` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `address` text CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `customer_id` int(11) DEFAULT NULL,
  `location_link` text CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  KEY `customer_id` (`customer_id`),
  KEY `store_id` (`store_id`),
  KEY `id` (`id`),
  CONSTRAINT `db_shippingaddress_ibfk_1` FOREIGN KEY (`customer_id`) REFERENCES `db_customers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_shippingaddress_ibfk_2` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_shippingaddress` (`id`, `store_id`, `country_id`, `state_id`, `city`, `postcode`, `address`, `status`, `customer_id`, `location_link`) VALUES (1, 1, 1, NULL, NULL, '', '', 1, 1, NULL);
INSERT INTO `db_shippingaddress` (`id`, `store_id`, `country_id`, `state_id`, `city`, `postcode`, `address`, `status`, `customer_id`, `location_link`) VALUES (2, 2, NULL, NULL, NULL, NULL, NULL, 1, 2, NULL);


#
# TABLE STRUCTURE FOR: db_sitesettings
#

DROP TABLE IF EXISTS `db_sitesettings`;

CREATE TABLE `db_sitesettings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `version` varchar(10) DEFAULT NULL,
  `site_name` varchar(100) DEFAULT NULL,
  `logo` mediumtext DEFAULT NULL COMMENT 'path',
  `machine_id` text DEFAULT NULL,
  `domain` text DEFAULT NULL,
  `unique_code` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_sitesettings` (`id`, `version`, `site_name`, `logo`, `machine_id`, `domain`, `unique_code`) VALUES (1, '3.1', 'Shop Keeper', '/uploads/site/logo.png', '1', 'pointofsale.ozonepos.com', '4kcd2s8v9axrpm6gy1foh7tlqij5nw');


#
# TABLE STRUCTURE FOR: db_smsapi
#

DROP TABLE IF EXISTS `db_smsapi`;

CREATE TABLE `db_smsapi` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `info` varchar(150) DEFAULT NULL,
  `key` varchar(600) DEFAULT NULL,
  `key_value` varchar(600) DEFAULT NULL,
  `delete_bit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_smsapi_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_smsapi` (`id`, `store_id`, `info`, `key`, `key_value`, `delete_bit`) VALUES (29, 1, 'url', 'weblink', 'https://www.example.com/api/mt/SendSMS?', NULL);
INSERT INTO `db_smsapi` (`id`, `store_id`, `info`, `key`, `key_value`, `delete_bit`) VALUES (30, 1, 'mobile', 'mobiles', '', NULL);
INSERT INTO `db_smsapi` (`id`, `store_id`, `info`, `key`, `key_value`, `delete_bit`) VALUES (31, 1, 'message', 'message', '', NULL);
INSERT INTO `db_smsapi` (`id`, `store_id`, `info`, `key`, `key_value`, `delete_bit`) VALUES (32, 2, 'url', 'weblink', 'http://bulksmsbd.net/api/smsapi?api_key=gGW5xWjeGHCgFQCFRAbJ&type=text&senderid=8809617617705', NULL);
INSERT INTO `db_smsapi` (`id`, `store_id`, `info`, `key`, `key_value`, `delete_bit`) VALUES (33, 2, 'mobile', 'number', '', NULL);
INSERT INTO `db_smsapi` (`id`, `store_id`, `info`, `key`, `key_value`, `delete_bit`) VALUES (34, 2, 'message', 'message', '', NULL);


#
# TABLE STRUCTURE FOR: db_smstemplates
#

DROP TABLE IF EXISTS `db_smstemplates`;

CREATE TABLE `db_smstemplates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `template_name` varchar(100) DEFAULT NULL,
  `content` text DEFAULT NULL,
  `variables` text DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `undelete_bit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_smstemplates_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_smstemplates` (`id`, `store_id`, `template_name`, `content`, `variables`, `status`, `undelete_bit`) VALUES (1, 1, 'GREETING TO CUSTOMER ON SALES', 'Hi {{customer_name}},\r\nYour sales Id is {{sales_id}},\r\nSales Date {{sales_date}},\r\nTotal amount  {{sales_amount}},\r\nYou have paid  {{paid_amt}},\r\nand due amount is  {{due_amt}}\r\nThank you Visit Again', '{{customer_name}}<br>                          \r\n{{sales_id}}<br>\r\n{{sales_date}}<br>\r\n{{sales_amount}}<br>\r\n{{paid_amt}}<br>\r\n{{due_amt}}<br>\r\n{{store_name}}<br>\r\n{{store_mobile}}<br>\r\n{{store_address}}<br>\r\n{{store_website}}<br>\r\n{{store_email}}<br>\r\n', 1, 1);
INSERT INTO `db_smstemplates` (`id`, `store_id`, `template_name`, `content`, `variables`, `status`, `undelete_bit`) VALUES (2, 1, 'GREETING TO CUSTOMER ON SALES RETURN', 'Hi {{customer_name}},\r\nYour sales return Id is {{return_id}},\r\nReturn Date {{return_date}},\r\nTotal amount  {{return_amount}},\r\nWe paid  {{paid_amt}},\r\nand due amount is  {{due_amt}}\r\nThank you Visit Again', '{{customer_name}}<br>                          \r\n{{return_id}}<br>\r\n{{return_date}}<br>\r\n{{return_amount}}<br>\r\n{{paid_amt}}<br>\r\n{{due_amt}}<br>\r\n{{company_name}}<br>\r\n{{company_mobile}}<br>\r\n{{company_address}}<br>\r\n{{company_website}}<br>\r\n{{company_email}}<br>', 1, 1);
INSERT INTO `db_smstemplates` (`id`, `store_id`, `template_name`, `content`, `variables`, `status`, `undelete_bit`) VALUES (12, 2, 'GREETING TO CUSTOMER ON SALES', 'Hi {{customer_name}},\r\nYour sales Id is {{sales_id}},\r\nSales Date {{sales_date}},\r\nTotal amount  {{sales_amount}},\r\nYou have paid  {{paid_amt}},\r\nand due amount is  {{due_amt}}\r\nThank you Visit Again', '{{customer_name}}                          \r\n{{sales_id}}\r\n{{sales_date}}\r\n{{sales_amount}}\r\n{{paid_amt}}\r\n{{due_amt}}\r\n{{store_name}}\r\n{{store_mobile}}\r\n{{store_address}}\r\n{{store_website}}\r\n{{store_email}}\r\n', 1, 1);
INSERT INTO `db_smstemplates` (`id`, `store_id`, `template_name`, `content`, `variables`, `status`, `undelete_bit`) VALUES (13, 2, 'GREETING TO CUSTOMER ON SALES RETURN', 'Hi {{customer_name}},\r\nYour sales return Id is {{return_id}},\r\nReturn Date {{return_date}},\r\nTotal amount  {{return_amount}},\r\nWe paid  {{paid_amt}},\r\nand due amount is  {{due_amt}}\r\nThank you Visit Again', '{{customer_name}}                          \r\n{{return_id}}\r\n{{return_date}}\r\n{{return_amount}}\r\n{{paid_amt}}\r\n{{due_amt}}\r\n{{company_name}}\r\n{{company_mobile}}\r\n{{company_address}}\r\n{{company_website}}\r\n{{company_email}}\r\n', 1, 1);


#
# TABLE STRUCTURE FOR: db_sobpayments
#

DROP TABLE IF EXISTS `db_sobpayments`;

CREATE TABLE `db_sobpayments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `supplier_id` int(11) DEFAULT NULL,
  `payment_date` date DEFAULT NULL,
  `payment_type` varchar(50) DEFAULT NULL,
  `payment` double(10,2) DEFAULT NULL,
  `payment_note` mediumtext DEFAULT NULL,
  `system_ip` varchar(50) DEFAULT NULL,
  `system_name` varchar(50) DEFAULT NULL,
  `created_time` time DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_by` varchar(50) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_states
#

DROP TABLE IF EXISTS `db_states`;

CREATE TABLE `db_states` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `state_code` varchar(10) DEFAULT NULL,
  `state` varchar(4050) DEFAULT NULL,
  `country_code` varchar(15) DEFAULT NULL,
  `country_id` int(11) DEFAULT NULL,
  `country` varchar(15) DEFAULT NULL,
  `added_on` date DEFAULT NULL,
  `company_id` int(11) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_states_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=71 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_states` (`id`, `store_id`, `state_code`, `state`, `country_code`, `country_id`, `country`, `added_on`, `company_id`, `status`) VALUES (64, 2, NULL, 'Barisal Division', NULL, NULL, 'Bangladesh', NULL, NULL, 1);
INSERT INTO `db_states` (`id`, `store_id`, `state_code`, `state`, `country_code`, `country_id`, `country`, `added_on`, `company_id`, `status`) VALUES (65, 2, NULL, 'Chittagong Division', NULL, NULL, 'Bangladesh', NULL, NULL, 1);
INSERT INTO `db_states` (`id`, `store_id`, `state_code`, `state`, `country_code`, `country_id`, `country`, `added_on`, `company_id`, `status`) VALUES (66, 2, NULL, 'Dhaka Division', NULL, NULL, 'Bangladesh', NULL, NULL, 1);
INSERT INTO `db_states` (`id`, `store_id`, `state_code`, `state`, `country_code`, `country_id`, `country`, `added_on`, `company_id`, `status`) VALUES (67, 2, NULL, 'Khulna Division', NULL, NULL, 'Bangladesh', NULL, NULL, 1);
INSERT INTO `db_states` (`id`, `store_id`, `state_code`, `state`, `country_code`, `country_id`, `country`, `added_on`, `company_id`, `status`) VALUES (68, 2, NULL, 'Rajshahi Division', NULL, NULL, 'Bangladesh', NULL, NULL, 1);
INSERT INTO `db_states` (`id`, `store_id`, `state_code`, `state`, `country_code`, `country_id`, `country`, `added_on`, `company_id`, `status`) VALUES (69, 2, NULL, 'Rangpur Division', NULL, NULL, 'Bangladesh', NULL, NULL, 1);
INSERT INTO `db_states` (`id`, `store_id`, `state_code`, `state`, `country_code`, `country_id`, `country`, `added_on`, `company_id`, `status`) VALUES (70, 2, NULL, 'Sylhet Division', NULL, NULL, 'Bangladesh', NULL, NULL, 1);


#
# TABLE STRUCTURE FOR: db_stockadjustment
#

DROP TABLE IF EXISTS `db_stockadjustment`;

CREATE TABLE `db_stockadjustment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `warehouse_id` int(11) DEFAULT NULL,
  `reference_no` varchar(50) DEFAULT NULL,
  `adjustment_date` date DEFAULT NULL,
  `adjustment_note` mediumtext DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) DEFAULT NULL,
  `created_by` varchar(50) DEFAULT NULL,
  `system_ip` varchar(100) DEFAULT NULL,
  `system_name` varchar(100) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_stockadjustment_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (18, 2, 2, NULL, '2022-08-09', NULL, '2022-08-09', '12:00:19 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (19, 2, 2, NULL, '2022-08-09', NULL, '2022-08-09', '01:38:51 pm', 'Chris', '37.28.46.147', 'dynamic.isp.ooredoo.om', 1);
INSERT INTO `db_stockadjustment` (`id`, `store_id`, `warehouse_id`, `reference_no`, `adjustment_date`, `adjustment_note`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`) VALUES (20, 2, 2, NULL, '2022-08-10', NULL, '2022-08-10', '09:23:28 am', 'Chris', '5.21.237.233', '5.21.237.233', 1);


#
# TABLE STRUCTURE FOR: db_stockadjustmentitems
#

DROP TABLE IF EXISTS `db_stockadjustmentitems`;

CREATE TABLE `db_stockadjustmentitems` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `warehouse_id` int(11) DEFAULT NULL,
  `adjustment_id` int(11) DEFAULT NULL,
  `item_id` int(11) DEFAULT NULL,
  `adjustment_qty` double(20,2) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `description` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `purchase_id` (`adjustment_id`),
  KEY `item_id` (`item_id`),
  KEY `store_id` (`store_id`),
  KEY `warehouse_id` (`warehouse_id`),
  CONSTRAINT `db_stockadjustmentitems_ibfk_1` FOREIGN KEY (`adjustment_id`) REFERENCES `db_stockadjustment` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_stockadjustmentitems_ibfk_2` FOREIGN KEY (`item_id`) REFERENCES `db_items` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_stockadjustmentitems_ibfk_3` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_stockadjustmentitems_ibfk_4` FOREIGN KEY (`warehouse_id`) REFERENCES `db_warehouse` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=366 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_stockentry
#

DROP TABLE IF EXISTS `db_stockentry`;

CREATE TABLE `db_stockentry` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `entry_date` date DEFAULT NULL,
  `item_id` int(11) DEFAULT NULL,
  `qty` int(11) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_stocktransfer
#

DROP TABLE IF EXISTS `db_stocktransfer`;

CREATE TABLE `db_stocktransfer` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL COMMENT 'from store',
  `to_store_id` int(11) DEFAULT NULL COMMENT 'to store transfer',
  `warehouse_from` int(11) DEFAULT NULL,
  `warehouse_to` int(11) DEFAULT NULL,
  `transfer_date` date DEFAULT NULL,
  `note` text CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `created_by` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `system_ip` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `system_name` varchar(50) CHARACTER SET latin1 COLLATE latin1_swedish_ci DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `warehouse_id` (`warehouse_from`),
  KEY `warehouse_to` (`warehouse_to`),
  KEY `db_stocktransfer_ibfk_4` (`to_store_id`),
  CONSTRAINT `db_stocktransfer_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_stocktransfer_ibfk_2` FOREIGN KEY (`warehouse_from`) REFERENCES `db_warehouse` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_stocktransfer_ibfk_3` FOREIGN KEY (`warehouse_to`) REFERENCES `db_warehouse` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_stocktransfer_ibfk_4` FOREIGN KEY (`to_store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_stocktransfer` (`id`, `store_id`, `to_store_id`, `warehouse_from`, `warehouse_to`, `transfer_date`, `note`, `created_by`, `created_date`, `created_time`, `system_ip`, `system_name`, `status`) VALUES (1, 2, NULL, 2, 86, '2022-08-09', '', 'Chris', '2022-08-09', '02:02:41 pm', '37.28.46.147', 'dynamic.isp.ooredoo.om', 1);


#
# TABLE STRUCTURE FOR: db_stocktransferitems
#

DROP TABLE IF EXISTS `db_stocktransferitems`;

CREATE TABLE `db_stocktransferitems` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `stocktransfer_id` int(11) DEFAULT NULL,
  `store_id` int(11) DEFAULT NULL COMMENT 'from store',
  `to_store_id` int(11) DEFAULT NULL COMMENT 'to store',
  `warehouse_from` int(11) DEFAULT NULL COMMENT 'warehouse ids',
  `warehouse_to` int(11) DEFAULT NULL COMMENT 'warehouse ids',
  `item_id` int(11) DEFAULT NULL,
  `transfer_qty` double(20,2) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `warehouse_from` (`warehouse_from`),
  KEY `warehouse_to` (`warehouse_to`),
  KEY `stocktranfer_id` (`stocktransfer_id`),
  KEY `item_id` (`item_id`),
  KEY `db_stocktransferitems_ibfk_6` (`to_store_id`),
  CONSTRAINT `db_stocktransferitems_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_stocktransferitems_ibfk_2` FOREIGN KEY (`warehouse_from`) REFERENCES `db_warehouse` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_stocktransferitems_ibfk_3` FOREIGN KEY (`warehouse_to`) REFERENCES `db_warehouse` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_stocktransferitems_ibfk_4` FOREIGN KEY (`stocktransfer_id`) REFERENCES `db_stocktransfer` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_stocktransferitems_ibfk_5` FOREIGN KEY (`item_id`) REFERENCES `db_items` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_stocktransferitems_ibfk_6` FOREIGN KEY (`to_store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=90 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_store
#

DROP TABLE IF EXISTS `db_store`;

CREATE TABLE `db_store` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_code` varchar(150) DEFAULT NULL,
  `store_name` varchar(150) DEFAULT NULL,
  `store_website` varchar(150) DEFAULT NULL,
  `mobile` varchar(150) DEFAULT NULL,
  `phone` varchar(150) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `website` varchar(250) DEFAULT NULL,
  `store_logo` text DEFAULT NULL,
  `logo` mediumtext DEFAULT NULL,
  `upi_id` varchar(50) DEFAULT NULL,
  `upi_code` text DEFAULT NULL,
  `country` varchar(150) DEFAULT NULL,
  `state` varchar(150) DEFAULT NULL,
  `city` varchar(100) DEFAULT NULL,
  `address` varchar(300) DEFAULT NULL,
  `postcode` varchar(50) DEFAULT NULL,
  `gst_no` varchar(50) DEFAULT NULL,
  `vat_no` varchar(50) DEFAULT NULL,
  `pan_no` varchar(50) DEFAULT NULL,
  `bank_details` mediumtext DEFAULT NULL,
  `cid` int(11) DEFAULT NULL,
  `category_init` varchar(50) DEFAULT NULL,
  `item_init` varchar(50) DEFAULT NULL COMMENT 'INITAL CODE',
  `supplier_init` varchar(50) DEFAULT NULL COMMENT 'INITAL CODE',
  `purchase_init` varchar(50) DEFAULT NULL COMMENT 'INITAL CODE',
  `purchase_return_init` varchar(50) DEFAULT NULL,
  `customer_init` varchar(50) DEFAULT NULL COMMENT 'INITAL CODE',
  `sales_init` varchar(50) DEFAULT NULL COMMENT 'INITAL CODE',
  `sales_return_init` varchar(50) DEFAULT NULL,
  `expense_init` varchar(50) DEFAULT NULL,
  `accounts_init` varchar(50) DEFAULT NULL,
  `journal_init` varchar(50) DEFAULT NULL,
  `cust_advance_init` varchar(50) DEFAULT NULL,
  `invoice_view` int(11) DEFAULT NULL COMMENT '1=Standard,2=Indian GST',
  `sms_status` int(11) DEFAULT NULL COMMENT '1=Enable 0=Disable',
  `status` int(11) DEFAULT NULL,
  `language_id` int(11) DEFAULT NULL,
  `currency_id` int(11) DEFAULT NULL,
  `currency_placement` varchar(50) DEFAULT NULL,
  `timezone` varchar(50) DEFAULT NULL,
  `date_format` varchar(50) DEFAULT NULL,
  `time_format` int(11) DEFAULT NULL,
  `sales_discount` double(20,4) DEFAULT NULL,
  `currencysymbol_id` int(11) DEFAULT NULL,
  `regno_key` varchar(50) DEFAULT NULL,
  `fav_icon` text DEFAULT NULL,
  `purchase_code` text DEFAULT NULL,
  `change_return` int(11) DEFAULT NULL,
  `sales_invoice_format_id` int(11) DEFAULT NULL,
  `pos_invoice_format_id` int(11) DEFAULT NULL,
  `sales_invoice_footer_text` text DEFAULT NULL,
  `round_off` int(11) DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) DEFAULT NULL,
  `created_by` varchar(50) DEFAULT NULL,
  `system_ip` varchar(50) DEFAULT NULL,
  `system_name` varchar(50) DEFAULT NULL,
  `quotation_init` varchar(50) DEFAULT NULL,
  `decimals` int(11) DEFAULT 2,
  `money_transfer_init` varchar(50) DEFAULT NULL,
  `sales_payment_init` varchar(50) DEFAULT NULL,
  `sales_return_payment_init` varchar(50) DEFAULT NULL,
  `purchase_payment_init` varchar(50) DEFAULT NULL,
  `purchase_return_payment_init` varchar(50) DEFAULT NULL,
  `expense_payment_init` varchar(50) DEFAULT NULL,
  `current_subscriptionlist_id` int(11) DEFAULT 0,
  `smtp_host` varchar(250) DEFAULT NULL,
  `smtp_port` varchar(250) DEFAULT NULL,
  `smtp_user` varchar(250) DEFAULT NULL,
  `smtp_pass` varchar(250) DEFAULT NULL,
  `smtp_status` int(11) DEFAULT 0,
  `sms_url` text DEFAULT NULL,
  `user_id` int(11) NOT NULL,
  `mrp_column` int(11) DEFAULT 0,
  `invoice_terms` text DEFAULT NULL,
  `previous_balance_bit` int(11) DEFAULT 1 COMMENT '1=Show, 0=Hide - Shows on sales invoice',
  `qty_decimals` int(11) DEFAULT 2,
  `signature` text DEFAULT NULL,
  `show_signature` int(11) DEFAULT 0,
  `t_and_c_status` int(11) DEFAULT 1 COMMENT '1=Show, 0=Hide - Shows on sales invoice',
  `t_and_c_status_pos` int(11) DEFAULT 1,
  `number_to_words` varchar(250) DEFAULT 'Default',
  `default_account_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_store` (`id`, `store_code`, `store_name`, `store_website`, `mobile`, `phone`, `email`, `website`, `store_logo`, `logo`, `upi_id`, `upi_code`, `country`, `state`, `city`, `address`, `postcode`, `gst_no`, `vat_no`, `pan_no`, `bank_details`, `cid`, `category_init`, `item_init`, `supplier_init`, `purchase_init`, `purchase_return_init`, `customer_init`, `sales_init`, `sales_return_init`, `expense_init`, `accounts_init`, `journal_init`, `cust_advance_init`, `invoice_view`, `sms_status`, `status`, `language_id`, `currency_id`, `currency_placement`, `timezone`, `date_format`, `time_format`, `sales_discount`, `currencysymbol_id`, `regno_key`, `fav_icon`, `purchase_code`, `change_return`, `sales_invoice_format_id`, `pos_invoice_format_id`, `sales_invoice_footer_text`, `round_off`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `quotation_init`, `decimals`, `money_transfer_init`, `sales_payment_init`, `sales_return_payment_init`, `purchase_payment_init`, `purchase_return_payment_init`, `expense_payment_init`, `current_subscriptionlist_id`, `smtp_host`, `smtp_port`, `smtp_user`, `smtp_pass`, `smtp_status`, `sms_url`, `user_id`, `mrp_column`, `invoice_terms`, `previous_balance_bit`, `qty_decimals`, `signature`, `show_signature`, `t_and_c_status`, `t_and_c_status_pos`, `number_to_words`, `default_account_id`) VALUES (1, 'ST0001', 'SAAS ADMIN', '', '+919999999999', '', 'admin@example.com', 'www', 'uploads/store/company_logo.png', NULL, NULL, NULL, 'India', 'Karnataka', 'Bengalore', 'Gandhi Road', '', '', '', '', '', NULL, 'CT/01/', 'IT01', 'SU/01/', 'PU/2020/01', 'PR/2020/01/', 'CU/01/', 'SL/2020/01/', 'SR/2020/01/', 'EX/2020/01/', 'AC/01/', 'JE', 'ADV', 1, 0, 1, 1, 35, 'Left', 'Asia/Kolkata\r\n', 'dd-mm-yyyy', 12, '0.0000', NULL, NULL, NULL, NULL, 1, 3, 1, 'Its Footer, You can change it from Store Settings.', 0, NULL, NULL, NULL, NULL, NULL, 'QT/2020/01/', 2, 'MT/01/', 'SP/2020/01/', 'SRP/2020/01/', 'PP/2020/01/', 'PRP/2020/01/', 'XP/2020/01/', 26, 'ssl://smtp.gmail.com', '465', 'salmanpathanindia@gmail.com', '9632563672', 1, 'http://sms.proware.in/api/sendhttp.php?authkey=248050Asbku6K75bf27efc&amp;mobiles={{MOBILE}}&amp;message={{MESSAGE}}&amp;sender=WBMGIC&amp;route=4', 0, 0, NULL, 1, 2, NULL, 0, 1, 1, 'Default', NULL);
INSERT INTO `db_store` (`id`, `store_code`, `store_name`, `store_website`, `mobile`, `phone`, `email`, `website`, `store_logo`, `logo`, `upi_id`, `upi_code`, `country`, `state`, `city`, `address`, `postcode`, `gst_no`, `vat_no`, `pan_no`, `bank_details`, `cid`, `category_init`, `item_init`, `supplier_init`, `purchase_init`, `purchase_return_init`, `customer_init`, `sales_init`, `sales_return_init`, `expense_init`, `accounts_init`, `journal_init`, `cust_advance_init`, `invoice_view`, `sms_status`, `status`, `language_id`, `currency_id`, `currency_placement`, `timezone`, `date_format`, `time_format`, `sales_discount`, `currencysymbol_id`, `regno_key`, `fav_icon`, `purchase_code`, `change_return`, `sales_invoice_format_id`, `pos_invoice_format_id`, `sales_invoice_footer_text`, `round_off`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `quotation_init`, `decimals`, `money_transfer_init`, `sales_payment_init`, `sales_return_payment_init`, `purchase_payment_init`, `purchase_return_payment_init`, `expense_payment_init`, `current_subscriptionlist_id`, `smtp_host`, `smtp_port`, `smtp_user`, `smtp_pass`, `smtp_status`, `sms_url`, `user_id`, `mrp_column`, `invoice_terms`, `previous_balance_bit`, `qty_decimals`, `signature`, `show_signature`, `t_and_c_status`, `t_and_c_status_pos`, `number_to_words`, `default_account_id`) VALUES (2, 'ST0002', 'AR Departmental Store', 'www.elitedesign.com.bd', '01775457008', '01954578089', 'info@elitedesign.com.bd', NULL, 'uploads/store/12.png', NULL, NULL, NULL, 'Bangladesh', 'Rangpur Division', 'Lalmonir Hat', 'House: Munsi Bari,Beside Nayar Hat High School,Borobari,Lalmonir Hat', '5500', '', '', '', 'Accounts: 128474444444\r\nHolder: Md Abu Sayed\r\nBank Name: EBL Bank', NULL, 'CT', 'IT02', 'SU', 'PU', 'PR', 'CU', 'SL', 'SR', 'EX', 'AC', NULL, 'ADV', 1, 1, 1, 1, 60, 'Left', 'Asia/Dhaka\r\n', 'dd-mm-yyyy', 12, '0.0000', NULL, NULL, NULL, NULL, 1, 3, 1, 'সালাত কায়েম করুন, ধন্যবাদ আবার আসবেন।', 1, '2021-02-12', '05:53:37 pm', '', '127.0.0.1', 'LAPTOP-I5OUIM4R', 'QT', 3, 'MT', 'SP', 'SRP', 'PP', 'PRP', 'XP', 28, 'mail.elitedesign.com.bd', '465', 'noreply@elitedesign.com.bd', 'ASrJ=mxsfphN', 1, NULL, 0, 1, 'ব্রিদ্রঃ বিক্রয়কৃত কোন পণ্য ফেরত নেওয়া হয় না।', 1, 2, 'uploads/signature/signature.png', 1, 1, 1, 'Default', 1);


#
# TABLE STRUCTURE FOR: db_stripe
#

DROP TABLE IF EXISTS `db_stripe`;

CREATE TABLE `db_stripe` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `sandbox` int(11) DEFAULT NULL,
  `publishable_key` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `api_secret` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `updated_at` date DEFAULT NULL,
  `updated_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_stripe_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_stripepayments
#

DROP TABLE IF EXISTS `db_stripepayments`;

CREATE TABLE `db_stripepayments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL,
  `buyer_name` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `buyer_email` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `paid_amount` varchar(10) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `paid_amount_currency` varchar(10) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `txn_id` varchar(50) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `payment_status` varchar(25) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,
  `created` datetime NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_subscription
#

DROP TABLE IF EXISTS `db_subscription`;

CREATE TABLE `db_subscription` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `payment_id` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `package_id` int(11) DEFAULT NULL,
  `package_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `package_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `subscription_date` date DEFAULT NULL,
  `expire_date` date DEFAULT NULL,
  `trial_days` int(11) DEFAULT NULL,
  `max_users` int(11) DEFAULT NULL,
  `max_warehouses` int(11) DEFAULT NULL,
  `max_items` int(11) DEFAULT NULL,
  `max_invoices` int(11) DEFAULT NULL,
  `payment_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `txn_id` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `payment_gross` double(10,2) DEFAULT NULL,
  `currency_code` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `payer_email` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `payment_status` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `system_ip` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `system_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `package_status` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `payment_type` varchar(250) DEFAULT NULL COMMENT 'manual subscription only',
  `package_count` int(11) DEFAULT NULL COMMENT 'manual subscription only',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_subscription` (`id`, `store_id`, `payment_id`, `package_id`, `package_type`, `package_name`, `description`, `subscription_date`, `expire_date`, `trial_days`, `max_users`, `max_warehouses`, `max_items`, `max_invoices`, `payment_by`, `txn_id`, `payment_gross`, `currency_code`, `payer_email`, `payment_status`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `package_status`, `payment_type`, `package_count`) VALUES (13, 22, NULL, 2, NULL, 'Regular', 'Test description', '2021-01-25', NULL, 15, 20, 20, 200, 200, 'PayPal', '48R18927X78299709', '250.00', 'USD', 'sb-9fy504805522@business.example.com', 'Pending', '2021-01-25', '01:30:45 pm', 'Tester', '127.0.0.1', 'LAPTOP-I5OUIM4R', NULL, NULL, NULL);
INSERT INTO `db_subscription` (`id`, `store_id`, `payment_id`, `package_id`, `package_type`, `package_name`, `description`, `subscription_date`, `expire_date`, `trial_days`, `max_users`, `max_warehouses`, `max_items`, `max_invoices`, `payment_by`, `txn_id`, `payment_gross`, `currency_code`, `payer_email`, `payment_status`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `package_status`, `payment_type`, `package_count`) VALUES (14, 22, NULL, 2, 'Paid', 'Regular', 'Test description', '2021-01-25', NULL, 15, 20, 20, 200, 200, 'PayPal', '9M838440FH9266015', '250.00', 'USD', 'sb-9fy504805522@business.example.com', 'Pending', '2021-01-25', '01:32:28 pm', 'Tester', '127.0.0.1', 'LAPTOP-I5OUIM4R', NULL, NULL, NULL);
INSERT INTO `db_subscription` (`id`, `store_id`, `payment_id`, `package_id`, `package_type`, `package_name`, `description`, `subscription_date`, `expire_date`, `trial_days`, `max_users`, `max_warehouses`, `max_items`, `max_invoices`, `payment_by`, `txn_id`, `payment_gross`, `currency_code`, `payer_email`, `payment_status`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `package_status`, `payment_type`, `package_count`) VALUES (16, 22, NULL, 2, 'Paid', 'Regular', 'Test description', '2021-01-25', '2021-02-25', 15, 20, 20, 200, 200, 'PayPal', '2PT61144W90213341', '250.00', 'USD', 'sb-9fy504805522@business.example.com', 'Pending', '2021-01-25', '02:00:38 pm', 'Tester', '127.0.0.1', 'LAPTOP-I5OUIM4R', NULL, NULL, NULL);
INSERT INTO `db_subscription` (`id`, `store_id`, `payment_id`, `package_id`, `package_type`, `package_name`, `description`, `subscription_date`, `expire_date`, `trial_days`, `max_users`, `max_warehouses`, `max_items`, `max_invoices`, `payment_by`, `txn_id`, `payment_gross`, `currency_code`, `payer_email`, `payment_status`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `package_status`, `payment_type`, `package_count`) VALUES (26, 1, NULL, 1, 'Free', 'Free', 'Test description', '2021-01-25', '2021-02-04', 10, 2, 2, 20, 20, 'Self', '', '0.00', '', '', '', '2021-01-25', '06:32:32 pm', 'admin', '127.0.0.1', 'LAPTOP-I5OUIM4R', NULL, NULL, NULL);
INSERT INTO `db_subscription` (`id`, `store_id`, `payment_id`, `package_id`, `package_type`, `package_name`, `description`, `subscription_date`, `expire_date`, `trial_days`, `max_users`, `max_warehouses`, `max_items`, `max_invoices`, `payment_by`, `txn_id`, `payment_gross`, `currency_code`, `payer_email`, `payment_status`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `package_status`, `payment_type`, `package_count`) VALUES (27, 24, NULL, 1, 'Free', 'Free', 'Test description', '2021-02-11', '2021-02-21', 10, 2, 2, 20, 20, 'Self', '', '0.00', '', '', '', '2021-02-11', '03:09:47 pm', 'Tester', '127.0.0.1', 'LAPTOP-I5OUIM4R', NULL, NULL, NULL);
INSERT INTO `db_subscription` (`id`, `store_id`, `payment_id`, `package_id`, `package_type`, `package_name`, `description`, `subscription_date`, `expire_date`, `trial_days`, `max_users`, `max_warehouses`, `max_items`, `max_invoices`, `payment_by`, `txn_id`, `payment_gross`, `currency_code`, `payer_email`, `payment_status`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `package_status`, `payment_type`, `package_count`) VALUES (28, 2, NULL, 1, 'Free', 'Free', 'Test description', '2021-02-12', '2021-02-22', 10, 2, 2, 20, 20, 'Self', '', '0.00', '', '', '', '2021-02-12', '06:57:18 pm', 'Tester', '127.0.0.1', 'LAPTOP-I5OUIM4R', NULL, NULL, NULL);


#
# TABLE STRUCTURE FOR: db_supplier_payments
#

DROP TABLE IF EXISTS `db_supplier_payments`;

CREATE TABLE `db_supplier_payments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `purchasepayment_id` int(11) DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `payment_date` date DEFAULT NULL,
  `payment_type` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `payment` double(10,2) DEFAULT NULL,
  `payment_note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `system_ip` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `system_name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_time` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_date` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `created_by` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `purchasepayment_id` (`purchasepayment_id`),
  CONSTRAINT `db_supplier_payments_ibfk_1` FOREIGN KEY (`supplier_id`) REFERENCES `db_suppliers` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_supplier_payments_ibfk_2` FOREIGN KEY (`purchasepayment_id`) REFERENCES `db_purchasepayments` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=291 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_suppliers
#

DROP TABLE IF EXISTS `db_suppliers`;

CREATE TABLE `db_suppliers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `count_id` int(11) DEFAULT NULL COMMENT 'Use to create supplier Code',
  `supplier_code` varchar(20) DEFAULT NULL,
  `supplier_name` varchar(50) DEFAULT NULL,
  `mobile` varchar(15) DEFAULT NULL,
  `phone` varchar(15) DEFAULT NULL,
  `email` varchar(50) DEFAULT NULL,
  `gstin` varchar(100) DEFAULT NULL,
  `tax_number` varchar(50) DEFAULT NULL,
  `vatin` varchar(100) DEFAULT NULL,
  `opening_balance` double(20,4) DEFAULT NULL,
  `purchase_due` double(20,4) DEFAULT NULL,
  `purchase_return_due` double(20,4) DEFAULT NULL,
  `country_id` int(11) DEFAULT NULL,
  `state_id` int(11) DEFAULT NULL,
  `city` varchar(50) DEFAULT NULL,
  `postcode` varchar(10) DEFAULT NULL,
  `address` varchar(250) DEFAULT NULL,
  `system_ip` varchar(50) DEFAULT NULL,
  `system_name` varchar(50) DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(30) DEFAULT NULL,
  `created_by` varchar(50) DEFAULT NULL,
  `company_id` int(11) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_suppliers_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_suppliers` (`id`, `store_id`, `count_id`, `supplier_code`, `supplier_name`, `mobile`, `phone`, `email`, `gstin`, `tax_number`, `vatin`, `opening_balance`, `purchase_due`, `purchase_return_due`, `country_id`, `state_id`, `city`, `postcode`, `address`, `system_ip`, `system_name`, `created_date`, `created_time`, `created_by`, `company_id`, `status`) VALUES (1, 2, 1, 'SU0001', 'EZ tech', '', '', '', '', '', NULL, '0.0000', '0.0000', NULL, 0, 0, '', '', '', '37.28.46.147', 'dynamic.isp.ooredoo.om', '2022-08-09', '01:59:07 pm', 'Chris', NULL, 1);


#
# TABLE STRUCTURE FOR: db_tax
#

DROP TABLE IF EXISTS `db_tax`;

CREATE TABLE `db_tax` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `tax_name` varchar(50) DEFAULT NULL,
  `tax` double(20,4) DEFAULT NULL,
  `group_bit` int(11) DEFAULT NULL COMMENT '1=Yes, 0=No',
  `subtax_ids` varchar(10) DEFAULT NULL COMMENT 'Tax groups IDs',
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_tax_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=150 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_tax` (`id`, `store_id`, `tax_name`, `tax`, `group_bit`, `subtax_ids`, `status`) VALUES (149, 2, 'VAT', '5.0000', NULL, NULL, 1);


#
# TABLE STRUCTURE FOR: db_timezone
#

DROP TABLE IF EXISTS `db_timezone`;

CREATE TABLE `db_timezone` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `timezone` varchar(100) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=549 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (1, 'Africa/Abidjan\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (2, 'Africa/Accra\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (3, 'Africa/Addis_Ababa\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (4, 'Africa/Algiers\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (5, 'Africa/Asmara\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (6, 'Africa/Asmera\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (7, 'Africa/Bamako\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (8, 'Africa/Bangui\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (9, 'Africa/Banjul\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (10, 'Africa/Bissau\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (11, 'Africa/Blantyre\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (12, 'Africa/Brazzaville\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (13, 'Africa/Bujumbura\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (14, 'Africa/Cairo\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (15, 'Africa/Casablanca\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (16, 'Africa/Ceuta\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (17, 'Africa/Conakry\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (18, 'Africa/Dakar\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (19, 'Africa/Dar_es_Salaam\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (20, 'Africa/Djibouti\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (21, 'Africa/Douala\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (22, 'Africa/El_Aaiun\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (23, 'Africa/Freetown\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (24, 'Africa/Gaborone\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (25, 'Africa/Harare\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (26, 'Africa/Johannesburg\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (27, 'Africa/Juba\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (28, 'Africa/Kampala\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (29, 'Africa/Khartoum\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (30, 'Africa/Kigali\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (31, 'Africa/Kinshasa\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (32, 'Africa/Lagos\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (33, 'Africa/Libreville\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (34, 'Africa/Lome\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (35, 'Africa/Luanda\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (36, 'Africa/Lubumbashi\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (37, 'Africa/Lusaka\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (38, 'Africa/Malabo\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (39, 'Africa/Maputo\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (40, 'Africa/Maseru\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (41, 'Africa/Mbabane\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (42, 'Africa/Mogadishu\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (43, 'Africa/Monrovia\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (44, 'Africa/Nairobi\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (45, 'Africa/Ndjamena\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (46, 'Africa/Niamey\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (47, 'Africa/Nouakchott\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (48, 'Africa/Ouagadougou\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (49, 'Africa/Porto-Novo\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (50, 'Africa/Sao_Tome\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (51, 'Africa/Timbuktu\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (52, 'Africa/Tripoli\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (53, 'Africa/Tunis\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (54, 'Africa/Windhoek\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (55, 'AKST9AKDT\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (56, 'America/Adak\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (57, 'America/Anchorage\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (58, 'America/Anguilla\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (59, 'America/Antigua\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (60, 'America/Araguaina\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (61, 'America/Argentina/Buenos_Aires\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (62, 'America/Argentina/Catamarca\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (63, 'America/Argentina/ComodRivadavia\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (64, 'America/Argentina/Cordoba\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (65, 'America/Argentina/Jujuy\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (66, 'America/Argentina/La_Rioja\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (67, 'America/Argentina/Mendoza\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (68, 'America/Argentina/Rio_Gallegos\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (69, 'America/Argentina/Salta\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (70, 'America/Argentina/San_Juan\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (71, 'America/Argentina/San_Luis\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (72, 'America/Argentina/Tucuman\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (73, 'America/Argentina/Ushuaia\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (74, 'America/Aruba\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (75, 'America/Asuncion\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (76, 'America/Atikokan\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (77, 'America/Atka\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (78, 'America/Bahia\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (79, 'America/Bahia_Banderas\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (80, 'America/Barbados\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (81, 'America/Belem\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (82, 'America/Belize\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (83, 'America/Blanc-Sablon\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (84, 'America/Boa_Vista\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (85, 'America/Bogota\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (86, 'America/Boise\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (87, 'America/Buenos_Aires\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (88, 'America/Cambridge_Bay\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (89, 'America/Campo_Grande\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (90, 'America/Cancun\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (91, 'America/Caracas\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (92, 'America/Catamarca\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (93, 'America/Cayenne\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (94, 'America/Cayman\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (95, 'America/Chicago\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (96, 'America/Chihuahua\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (97, 'America/Coral_Harbour\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (98, 'America/Cordoba\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (99, 'America/Costa_Rica\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (100, 'America/Creston\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (101, 'America/Cuiaba\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (102, 'America/Curacao\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (103, 'America/Danmarkshavn\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (104, 'America/Dawson\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (105, 'America/Dawson_Creek\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (106, 'America/Denver\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (107, 'America/Detroit\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (108, 'America/Dominica\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (109, 'America/Edmonton\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (110, 'America/Eirunepe\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (111, 'America/El_Salvador\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (112, 'America/Ensenada\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (113, 'America/Fort_Wayne\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (114, 'America/Fortaleza\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (115, 'America/Glace_Bay\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (116, 'America/Godthab\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (117, 'America/Goose_Bay\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (118, 'America/Grand_Turk\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (119, 'America/Grenada\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (120, 'America/Guadeloupe\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (121, 'America/Guatemala\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (122, 'America/Guayaquil\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (123, 'America/Guyana\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (124, 'America/Halifax\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (125, 'America/Havana\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (126, 'America/Hermosillo\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (127, 'America/Indiana/Indianapolis\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (128, 'America/Indiana/Knox\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (129, 'America/Indiana/Marengo\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (130, 'America/Indiana/Petersburg\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (131, 'America/Indiana/Tell_City\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (132, 'America/Indiana/Vevay\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (133, 'America/Indiana/Vincennes\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (134, 'America/Indiana/Winamac\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (135, 'America/Indianapolis\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (136, 'America/Inuvik\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (137, 'America/Iqaluit\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (138, 'America/Jamaica\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (139, 'America/Jujuy\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (140, 'America/Juneau\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (141, 'America/Kentucky/Louisville\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (142, 'America/Kentucky/Monticello\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (143, 'America/Knox_IN\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (144, 'America/Kralendijk\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (145, 'America/La_Paz\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (146, 'America/Lima\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (147, 'America/Los_Angeles\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (148, 'America/Louisville\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (149, 'America/Lower_Princes\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (150, 'America/Maceio\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (151, 'America/Managua\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (152, 'America/Manaus\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (153, 'America/Marigot\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (154, 'America/Martinique\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (155, 'America/Matamoros\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (156, 'America/Mazatlan\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (157, 'America/Mendoza\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (158, 'America/Menominee\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (159, 'America/Merida\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (160, 'America/Metlakatla\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (161, 'America/Mexico_City\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (162, 'America/Miquelon\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (163, 'America/Moncton\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (164, 'America/Monterrey\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (165, 'America/Montevideo\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (166, 'America/Montreal\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (167, 'America/Montserrat\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (168, 'America/Nassau\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (169, 'America/New_York\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (170, 'America/Nipigon\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (171, 'America/Nome\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (172, 'America/Noronha\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (173, 'America/North_Dakota/Beulah\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (174, 'America/North_Dakota/Center\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (175, 'America/North_Dakota/New_Salem\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (176, 'America/Ojinaga\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (177, 'America/Panama\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (178, 'America/Pangnirtung\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (179, 'America/Paramaribo\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (180, 'America/Phoenix\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (181, 'America/Port_of_Spain\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (182, 'America/Port-au-Prince\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (183, 'America/Porto_Acre\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (184, 'America/Porto_Velho\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (185, 'America/Puerto_Rico\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (186, 'America/Rainy_River\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (187, 'America/Rankin_Inlet\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (188, 'America/Recife\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (189, 'America/Regina\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (190, 'America/Resolute\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (191, 'America/Rio_Branco\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (192, 'America/Rosario\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (193, 'America/Santa_Isabel\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (194, 'America/Santarem\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (195, 'America/Santiago\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (196, 'America/Santo_Domingo\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (197, 'America/Sao_Paulo\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (198, 'America/Scoresbysund\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (199, 'America/Shiprock\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (200, 'America/Sitka\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (201, 'America/St_Barthelemy\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (202, 'America/St_Johns\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (203, 'America/St_Kitts\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (204, 'America/St_Lucia\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (205, 'America/St_Thomas\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (206, 'America/St_Vincent\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (207, 'America/Swift_Current\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (208, 'America/Tegucigalpa\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (209, 'America/Thule\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (210, 'America/Thunder_Bay\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (211, 'America/Tijuana\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (212, 'America/Toronto\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (213, 'America/Tortola\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (214, 'America/Vancouver\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (215, 'America/Virgin\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (216, 'America/Whitehorse\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (217, 'America/Winnipeg\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (218, 'America/Yakutat\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (219, 'America/Yellowknife\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (220, 'Antarctica/Casey\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (221, 'Antarctica/Davis\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (222, 'Antarctica/DumontDUrville\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (223, 'Antarctica/Macquarie\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (224, 'Antarctica/Mawson\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (225, 'Antarctica/McMurdo\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (226, 'Antarctica/Palmer\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (227, 'Antarctica/Rothera\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (228, 'Antarctica/South_Pole\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (229, 'Antarctica/Syowa\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (230, 'Antarctica/Vostok\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (231, 'Arctic/Longyearbyen\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (232, 'Asia/Aden\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (233, 'Asia/Almaty\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (234, 'Asia/Amman\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (235, 'Asia/Anadyr\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (236, 'Asia/Aqtau\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (237, 'Asia/Aqtobe\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (238, 'Asia/Ashgabat\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (239, 'Asia/Ashkhabad\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (240, 'Asia/Baghdad\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (241, 'Asia/Bahrain\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (242, 'Asia/Baku\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (243, 'Asia/Bangkok\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (244, 'Asia/Beirut\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (245, 'Asia/Bishkek\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (246, 'Asia/Brunei\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (247, 'Asia/Calcutta\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (248, 'Asia/Choibalsan\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (249, 'Asia/Chongqing\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (250, 'Asia/Chungking\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (251, 'Asia/Colombo\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (252, 'Asia/Dacca\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (253, 'Asia/Damascus\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (254, 'Asia/Dhaka\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (255, 'Asia/Dili\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (256, 'Asia/Dubai\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (257, 'Asia/Dushanbe\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (258, 'Asia/Gaza\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (259, 'Asia/Harbin\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (260, 'Asia/Hebron\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (261, 'Asia/Ho_Chi_Minh\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (262, 'Asia/Hong_Kong\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (263, 'Asia/Hovd\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (264, 'Asia/Irkutsk\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (265, 'Asia/Istanbul\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (266, 'Asia/Jakarta\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (267, 'Asia/Jayapura\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (268, 'Asia/Jerusalem\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (269, 'Asia/Kabul\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (270, 'Asia/Kamchatka\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (271, 'Asia/Karachi\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (272, 'Asia/Kashgar\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (273, 'Asia/Kathmandu\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (274, 'Asia/Katmandu\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (275, 'Asia/Kolkata\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (276, 'Asia/Krasnoyarsk\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (277, 'Asia/Kuala_Lumpur\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (278, 'Asia/Kuching\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (279, 'Asia/Kuwait\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (280, 'Asia/Macao\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (281, 'Asia/Macau\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (282, 'Asia/Magadan\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (283, 'Asia/Makassar\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (284, 'Asia/Manila\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (285, 'Asia/Muscat\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (286, 'Asia/Nicosia\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (287, 'Asia/Novokuznetsk\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (288, 'Asia/Novosibirsk\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (289, 'Asia/Omsk\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (290, 'Asia/Oral\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (291, 'Asia/Phnom_Penh\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (292, 'Asia/Pontianak\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (293, 'Asia/Pyongyang\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (294, 'Asia/Qatar\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (295, 'Asia/Qyzylorda\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (296, 'Asia/Rangoon\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (297, 'Asia/Riyadh\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (298, 'Asia/Saigon\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (299, 'Asia/Sakhalin\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (300, 'Asia/Samarkand\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (301, 'Asia/Seoul\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (302, 'Asia/Shanghai\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (303, 'Asia/Singapore\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (304, 'Asia/Taipei\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (305, 'Asia/Tashkent\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (306, 'Asia/Tbilisi\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (307, 'Asia/Tehran\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (308, 'Asia/Tel_Aviv\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (309, 'Asia/Thimbu\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (310, 'Asia/Thimphu\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (311, 'Asia/Tokyo\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (312, 'Asia/Ujung_Pandang\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (313, 'Asia/Ulaanbaatar\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (314, 'Asia/Ulan_Bator\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (315, 'Asia/Urumqi\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (316, 'Asia/Vientiane\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (317, 'Asia/Vladivostok\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (318, 'Asia/Yakutsk\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (319, 'Asia/Yekaterinburg\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (320, 'Asia/Yerevan\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (321, 'Atlantic/Azores\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (322, 'Atlantic/Bermuda\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (323, 'Atlantic/Canary\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (324, 'Atlantic/Cape_Verde\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (325, 'Atlantic/Faeroe\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (326, 'Atlantic/Faroe\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (327, 'Atlantic/Jan_Mayen\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (328, 'Atlantic/Madeira\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (329, 'Atlantic/Reykjavik\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (330, 'Atlantic/South_Georgia\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (331, 'Atlantic/St_Helena\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (332, 'Atlantic/Stanley\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (333, 'Australia/ACT\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (334, 'Australia/Adelaide\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (335, 'Australia/Brisbane\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (336, 'Australia/Broken_Hill\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (337, 'Australia/Canberra\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (338, 'Australia/Currie\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (339, 'Australia/Darwin\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (340, 'Australia/Eucla\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (341, 'Australia/Hobart\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (342, 'Australia/LHI\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (343, 'Australia/Lindeman\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (344, 'Australia/Lord_Howe\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (345, 'Australia/Melbourne\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (346, 'Australia/North\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (347, 'Australia/NSW\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (348, 'Australia/Perth\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (349, 'Australia/Queensland\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (350, 'Australia/South\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (351, 'Australia/Sydney\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (352, 'Australia/Tasmania\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (353, 'Australia/Victoria\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (354, 'Australia/West\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (355, 'Australia/Yancowinna\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (356, 'Brazil/Acre\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (357, 'Brazil/DeNoronha\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (358, 'Brazil/East\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (359, 'Brazil/West\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (360, 'Canada/Atlantic\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (361, 'Canada/Central\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (362, 'Canada/Eastern\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (363, 'Canada/East-Saskatchewan\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (364, 'Canada/Mountain\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (365, 'Canada/Newfoundland\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (366, 'Canada/Pacific\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (367, 'Canada/Saskatchewan\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (368, 'Canada/Yukon\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (369, 'CET\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (370, 'Chile/Continental\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (371, 'Chile/EasterIsland\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (372, 'CST6CDT\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (373, 'Cuba\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (374, 'EET\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (375, 'Egypt\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (376, 'Eire\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (377, 'EST\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (378, 'EST5EDT\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (379, 'Etc./GMT\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (380, 'Etc./GMT+0\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (381, 'Etc./UCT\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (382, 'Etc./Universal\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (383, 'Etc./UTC\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (384, 'Etc./Zulu\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (385, 'Europe/Amsterdam\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (386, 'Europe/Andorra\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (387, 'Europe/Athens\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (388, 'Europe/Belfast\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (389, 'Europe/Belgrade\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (390, 'Europe/Berlin\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (391, 'Europe/Bratislava\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (392, 'Europe/Brussels\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (393, 'Europe/Bucharest\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (394, 'Europe/Budapest\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (395, 'Europe/Chisinau\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (396, 'Europe/Copenhagen\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (397, 'Europe/Dublin\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (398, 'Europe/Gibraltar\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (399, 'Europe/Guernsey\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (400, 'Europe/Helsinki\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (401, 'Europe/Isle_of_Man\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (402, 'Europe/Istanbul\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (403, 'Europe/Jersey\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (404, 'Europe/Kaliningrad\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (405, 'Europe/Kiev\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (406, 'Europe/Lisbon\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (407, 'Europe/Ljubljana\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (408, 'Europe/London\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (409, 'Europe/Luxembourg\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (410, 'Europe/Madrid\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (411, 'Europe/Malta\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (412, 'Europe/Mariehamn\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (413, 'Europe/Minsk\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (414, 'Europe/Monaco\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (415, 'Europe/Moscow\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (416, 'Europe/Nicosia\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (417, 'Europe/Oslo\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (418, 'Europe/Paris\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (419, 'Europe/Podgorica\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (420, 'Europe/Prague\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (421, 'Europe/Riga\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (422, 'Europe/Rome\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (423, 'Europe/Samara\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (424, 'Europe/San_Marino\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (425, 'Europe/Sarajevo\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (426, 'Europe/Simferopol\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (427, 'Europe/Skopje\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (428, 'Europe/Sofia\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (429, 'Europe/Stockholm\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (430, 'Europe/Tallinn\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (431, 'Europe/Tirane\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (432, 'Europe/Tiraspol\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (433, 'Europe/Uzhgorod\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (434, 'Europe/Vaduz\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (435, 'Europe/Vatican\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (436, 'Europe/Vienna\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (437, 'Europe/Vilnius\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (438, 'Europe/Volgograd\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (439, 'Europe/Warsaw\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (440, 'Europe/Zagreb\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (441, 'Europe/Zaporozhye\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (442, 'Europe/Zurich\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (443, 'GB\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (444, 'GB-Eire\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (445, 'GMT\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (446, 'GMT+0\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (447, 'GMT0\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (448, 'GMT-0\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (449, 'Greenwich\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (450, 'Hong Kong\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (451, 'HST\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (452, 'Iceland\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (453, 'Indian/Antananarivo\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (454, 'Indian/Chagos\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (455, 'Indian/Christmas\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (456, 'Indian/Cocos\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (457, 'Indian/Comoro\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (458, 'Indian/Kerguelen\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (459, 'Indian/Mahe\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (460, 'Indian/Maldives\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (461, 'Indian/Mauritius\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (462, 'Indian/Mayotte\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (463, 'Indian/Reunion\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (464, 'Iran\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (465, 'Israel\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (466, 'Jamaica\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (467, 'Japan\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (468, 'JST-9\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (469, 'Kwajalein\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (470, 'Libya\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (471, 'MET\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (472, 'Mexico/BajaNorte\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (473, 'Mexico/BajaSur\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (474, 'Mexico/General\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (475, 'MST\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (476, 'MST7MDT\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (477, 'Navajo\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (478, 'NZ\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (479, 'NZ-CHAT\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (480, 'Pacific/Apia\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (481, 'Pacific/Auckland\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (482, 'Pacific/Chatham\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (483, 'Pacific/Chuuk\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (484, 'Pacific/Easter\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (485, 'Pacific/Efate\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (486, 'Pacific/Enderbury\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (487, 'Pacific/Fakaofo\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (488, 'Pacific/Fiji\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (489, 'Pacific/Funafuti\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (490, 'Pacific/Galapagos\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (491, 'Pacific/Gambier\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (492, 'Pacific/Guadalcanal\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (493, 'Pacific/Guam\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (494, 'Pacific/Honolulu\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (495, 'Pacific/Johnston\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (496, 'Pacific/Kiritimati\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (497, 'Pacific/Kosrae\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (498, 'Pacific/Kwajalein\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (499, 'Pacific/Majuro\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (500, 'Pacific/Marquesas\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (501, 'Pacific/Midway\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (502, 'Pacific/Nauru\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (503, 'Pacific/Niue\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (504, 'Pacific/Norfolk\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (505, 'Pacific/Noumea\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (506, 'Pacific/Pago_Pago\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (507, 'Pacific/Palau\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (508, 'Pacific/Pitcairn\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (509, 'Pacific/Pohnpei\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (510, 'Pacific/Ponape\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (511, 'Pacific/Port_Moresby\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (512, 'Pacific/Rarotonga\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (513, 'Pacific/Saipan\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (514, 'Pacific/Samoa\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (515, 'Pacific/Tahiti\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (516, 'Pacific/Tarawa\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (517, 'Pacific/Tongatapu\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (518, 'Pacific/Truk\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (519, 'Pacific/Wake\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (520, 'Pacific/Wallis\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (521, 'Pacific/Yap\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (522, 'Poland\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (523, 'Portugal\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (524, 'PRC\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (525, 'PST8PDT\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (526, 'ROC\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (527, 'ROK\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (528, 'Singapore\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (529, 'Turkey\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (530, 'UCT\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (531, 'Universal\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (532, 'US/Alaska\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (533, 'US/Aleutian\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (534, 'US/Arizona\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (535, 'US/Central\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (536, 'US/Eastern\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (537, 'US/East-Indiana\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (538, 'US/Hawaii\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (539, 'US/Indiana-Starke\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (540, 'US/Michigan\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (541, 'US/Mountain\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (542, 'US/Pacific\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (543, 'US/Pacific-New\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (544, 'US/Samoa\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (545, 'UTC\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (546, 'WET\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (547, 'W-SU\r', 1);
INSERT INTO `db_timezone` (`id`, `timezone`, `status`) VALUES (548, 'Zulu\r', 1);


#
# TABLE STRUCTURE FOR: db_twilio
#

DROP TABLE IF EXISTS `db_twilio`;

CREATE TABLE `db_twilio` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `account_sid` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `auth_token` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `twilio_phone` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL,
  `status` int(11) DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_twilio_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_twilio` (`id`, `store_id`, `account_sid`, `auth_token`, `twilio_phone`, `status`) VALUES (1, 1, '', '', '', 0);
INSERT INTO `db_twilio` (`id`, `store_id`, `account_sid`, `auth_token`, `twilio_phone`, `status`) VALUES (3, 2, '', '', '', 0);


#
# TABLE STRUCTURE FOR: db_units
#

DROP TABLE IF EXISTS `db_units`;

CREATE TABLE `db_units` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `unit_name` varchar(50) DEFAULT NULL,
  `description` mediumtext DEFAULT NULL,
  `company_id` int(11) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_units_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=63 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_units` (`id`, `store_id`, `unit_name`, `description`, `company_id`, `status`) VALUES (61, 2, 'PCS', '', NULL, 1);
INSERT INTO `db_units` (`id`, `store_id`, `unit_name`, `description`, `company_id`, `status`) VALUES (62, 2, 'KG', '', NULL, 1);


#
# TABLE STRUCTURE FOR: db_users
#

DROP TABLE IF EXISTS `db_users`;

CREATE TABLE `db_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `username` varchar(50) DEFAULT NULL,
  `first_name` varchar(100) DEFAULT NULL,
  `last_name` varchar(100) DEFAULT NULL,
  `password` blob DEFAULT NULL,
  `member_of` varchar(50) DEFAULT NULL,
  `firstname` varchar(50) DEFAULT NULL,
  `lastname` varchar(50) DEFAULT NULL,
  `mobile` varchar(50) DEFAULT NULL,
  `email` varchar(50) DEFAULT NULL,
  `photo` blob DEFAULT NULL,
  `gender` varchar(50) DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `country` varchar(50) DEFAULT NULL,
  `state` varchar(50) DEFAULT NULL,
  `city` varchar(50) DEFAULT NULL,
  `address` blob DEFAULT NULL,
  `postcode` varchar(50) DEFAULT NULL,
  `role_name` varchar(50) DEFAULT NULL,
  `role_id` int(11) DEFAULT NULL,
  `profile_picture` text DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) DEFAULT NULL,
  `created_by` varchar(50) DEFAULT NULL,
  `system_ip` varchar(100) DEFAULT NULL,
  `system_name` varchar(100) DEFAULT NULL,
  `status` double DEFAULT NULL,
  `creater_id` int(11) DEFAULT NULL,
  `updater_id` int(11) DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `default_warehouse_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_users_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=102 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_users` (`id`, `store_id`, `username`, `first_name`, `last_name`, `password`, `member_of`, `firstname`, `lastname`, `mobile`, `email`, `photo`, `gender`, `dob`, `country`, `state`, `city`, `address`, `postcode`, `role_name`, `role_id`, `profile_picture`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`, `creater_id`, `updater_id`, `updated_at`, `default_warehouse_id`) VALUES (1, 1, 'superadmin', 'Elite', 'Design', 'e10adc3949ba59abbe56e057f20f883e', '', NULL, NULL, '', 'super@elitedesign.com.bd', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'uploads/users/admin.png', '2018-11-27', '::1', NULL, NULL, NULL, '1', NULL, NULL, NULL, NULL);
INSERT INTO `db_users` (`id`, `store_id`, `username`, `first_name`, `last_name`, `password`, `member_of`, `firstname`, `lastname`, `mobile`, `email`, `photo`, `gender`, `dob`, `country`, `state`, `city`, `address`, `postcode`, `role_name`, `role_id`, `profile_picture`, `created_date`, `created_time`, `created_by`, `system_ip`, `system_name`, `status`, `creater_id`, `updater_id`, `updated_at`, `default_warehouse_id`) VALUES (2, 2, 'admin', 'Elite', 'Design', '25d55ad283aa400af464c76d713c07ad', NULL, NULL, NULL, '01775457008', 'info@elitedesign.com.bd', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 2, 'uploads/users/avatar1.png', '2021-02-12', '05:53:37 pm', '', '127.0.0.1', 'LAPTOP-I5OUIM4R', '1', NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: db_userswarehouses
#

DROP TABLE IF EXISTS `db_userswarehouses`;

CREATE TABLE `db_userswarehouses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `warehouse_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `warehouse_id` (`warehouse_id`),
  CONSTRAINT `db_userswarehouses_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `db_users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_userswarehouses_ibfk_2` FOREIGN KEY (`warehouse_id`) REFERENCES `db_warehouse` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=77 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_variants
#

DROP TABLE IF EXISTS `db_variants`;

CREATE TABLE `db_variants` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `variant_code` varchar(50) DEFAULT NULL,
  `variant_name` varchar(100) DEFAULT NULL,
  `description` mediumtext DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_variants_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_variants_ibfk_2` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=259 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: db_warehouse
#

DROP TABLE IF EXISTS `db_warehouse`;

CREATE TABLE `db_warehouse` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `warehouse_type` varchar(50) DEFAULT NULL,
  `warehouse_name` varchar(50) DEFAULT NULL,
  `mobile` varchar(20) DEFAULT NULL,
  `email` varchar(50) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  CONSTRAINT `db_warehouse_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=87 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `db_warehouse` (`id`, `store_id`, `warehouse_type`, `warehouse_name`, `mobile`, `email`, `status`, `created_date`) VALUES (1, 1, 'System', 'Warehouse-A', '', 'warehouse_a@example.com', 1, NULL);
INSERT INTO `db_warehouse` (`id`, `store_id`, `warehouse_type`, `warehouse_name`, `mobile`, `email`, `status`, `created_date`) VALUES (2, 2, 'System', 'System Warehouse', '', '', 1, NULL);
INSERT INTO `db_warehouse` (`id`, `store_id`, `warehouse_type`, `warehouse_name`, `mobile`, `email`, `status`, `created_date`) VALUES (86, 2, 'Custom', 'Al Amerat Store', '', '', 1, NULL);


#
# TABLE STRUCTURE FOR: db_warehouseitems
#

DROP TABLE IF EXISTS `db_warehouseitems`;

CREATE TABLE `db_warehouseitems` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `store_id` int(11) DEFAULT NULL,
  `warehouse_id` int(11) DEFAULT NULL,
  `item_id` int(11) DEFAULT NULL,
  `available_qty` double(20,2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `store_id` (`store_id`),
  KEY `warehouse_id` (`warehouse_id`),
  KEY `item_id` (`item_id`),
  CONSTRAINT `db_warehouseitems_ibfk_1` FOREIGN KEY (`store_id`) REFERENCES `db_store` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_warehouseitems_ibfk_2` FOREIGN KEY (`warehouse_id`) REFERENCES `db_warehouse` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `db_warehouseitems_ibfk_3` FOREIGN KEY (`item_id`) REFERENCES `db_items` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4231 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: temp_holdinvoice
#

DROP TABLE IF EXISTS `temp_holdinvoice`;

CREATE TABLE `temp_holdinvoice` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `invoice_id` int(11) DEFAULT NULL,
  `invoice_date` date DEFAULT NULL,
  `reference_id` varchar(50) DEFAULT NULL,
  `item_id` int(11) DEFAULT NULL,
  `item_qty` int(11) DEFAULT NULL,
  `item_price` double(10,2) DEFAULT NULL,
  `tax` double(10,2) DEFAULT NULL,
  `created_date` date DEFAULT NULL,
  `created_time` varchar(50) DEFAULT NULL,
  `created_by` varchar(50) DEFAULT NULL,
  `system_ip` varchar(50) DEFAULT NULL,
  `system_name` varchar(50) DEFAULT NULL,
  `pos` int(11) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

SET foreign_key_checks = 1;
